unit OOoXray3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, Buttons, ExtCtrls;

type
  TxrayForm3 = class(TForm)
    arrayGrid: TStringGrid;
    Panel1: TPanel;
    ExitBtn: TBitBtn;
    XrayBtn: TBitBtn;
    Label2: TLabel;
    ObjPath: TEdit;
    indexMin: TEdit;
    indexmax: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    procedure Display(thisArray: Variant; currObjPath: String);
    procedure arrayGridDblClick(Sender: TObject);
    procedure XrayBtnClick(Sender: TObject);
  private
    { Dclarations prives }
    thisArray2: Variant;
  public
    { Dclarations publiques }
    displayed: Boolean;
  end;

const
  XrayMarray= 'Array';  XrayMstruct= 'Structure';
  XrayMobject= 'Object';  XrayMstring= 'String';

var
  xrayForm3: TxrayForm3;

procedure displayValue(V1: Variant; var strV1, typeV1: String);
function  getShortTypeStr(thisIdlClass: Variant; var propReadable: Boolean): String;
procedure convertToGridValue(valProp: Variant; gridLine: TStrings; storeTypeString: Boolean);

implementation

{$R *.dfm}

uses OOoTools, OOoConstants, OOoXray, OOoXray2;

const // textes de messages
  mess300= '- Index -';   mess301= '- Type -';  mess302= '- Valeur -';
  mess303= 'Null Array';
  mess304= '< - - - - >'; // reprsente un string non affichable dans une case de Grid
  mess305= 'Chane de caractres de longueur nulle';



  { ---------------------------------------------------------------------- }

const
  moreInfosState= False; // valeur True donne plus d'infos, panneaux plus difficiles  lire
  maxStringLengthInGrid= 60;

const
  TypeClass2Basic : Array[0..31] of string = (
    'void',    'Char',    'Boolean', 'Byte',   'Smallint', 'Word', 'Integer',
    'Longword','Int64',   'Int64',   'Single', 'Double',  'String',  'type',
    'Variant', 'Integer', 'object',  'Structure','object','object',  'Array',
    'Array',   'object',  'object',  'object', 'object',  'object',  'unknown',
    'object',  'object',  'object',  'object');
  TypeClassIsPropReadable : Array[0..31] of Boolean = (
    False,     True,      True,      True,     True,      True,      True,
    True,      False,     False,     True,     True,      True,      False,
    False,     True,      False,     False,    False,     False,     False,
    False,     False,     False,     False,    False,     False,     False,
    False,     False,     False,     False)   ;


{ ------------------------------------------------------------------------- }

procedure displayValue(V1: Variant; var strV1, typeV1: String);

  procedure pre_analyze_Object;
  var
    classeIDL: Variant;   tc: Integer;
  begin
    classeIDL:= OOoReflection.getType(V1);   tc:= classeIDL.getTypeClass;
    if tc = _unoTypeClassSTRUCT  then begin
      typeV1:= XrayMstruct;  strV1:= classeIDL.getName;
      if  (strV1 = 'com.sun.star.beans.PropertyValue')  or
          (strV1 = 'com.sun.star.beans.Property')  then
        strV1:= strV1 + ' ----> ' + V1.Name;    // indiquer le nom de la proprit
    end else begin  // objet autre
        typeV1:= XrayMobject;  strV1:= '';
    end;
  end;

var
  lb, hb: Integer;
begin   { --------- displayValue ---------- }
  if VarArrayDimCount(v1) = 0 then begin { valeur unique }
    typeV1:= VarTypeAsText(VarType(V1));
    case VarType(V1) of
    varEmpty, varNull: strV1:= '';
    varByte: strV1:= IntToStr(V1) + '  ( $' + IntToHex(V1, 2) + ' )';
    varSmallInt, varWord: strV1:= IntToStr(V1) + '  ( $' + IntToHex(V1, 4) + ' )';
    varInteger, varLongWord:  strV1:= IntToStr(V1) + '  ( $' + IntToHex(V1, 8) + ' )';
    varInt64: strV1:= IntToStr(V1) + '  ( $' + IntToHex(V1, 16) + ' )';
    varDouble, varSingle: strV1:= FloatToStr(V1);
    varBoolean: strV1:= BoolToStr(V1, True);
    varString, varStrArg, varOleStr: begin
        strV1:= V1;        typeV1:= XrayMstring;
      end;
    varDispatch: pre_analyze_Object;
    else
      strV1:= '';
    end;
  end else begin
    typeV1:= XrayMarray;
    lb:= VarArrayLowBound(v1, 1); hb:= VarArrayHighBound(v1, 1);
    if hb < lb then
      strV1:= mess303  // 'Null Array'
    else
      strV1:= XrayMarray + '[' +IntToStr(lb) + '..' +IntToStr(hb) +']';
  end;
end;



function  getShortTypeStr(thisIdlClass: Variant; var propReadable: Boolean): String;
var
  tc: Integer;
begin
  tc:= thisIdlClass.TypeClass;
  if (tc = _unoTypeClassARRAY) or (tc = _unoTypeClassSEQUENCE)  then begin
    propReadable:= False;
    if moreInfosState  then
      Result:= '[]' +  thisIdlClass.ComponentType.Name
    else begin
      tc:= thisIdlClass.ComponentType.TypeClass;
      Result:= '[]' + TypeClass2Basic[tc];
    end;
  end else begin
    propReadable:= TypeClassIsPropReadable[tc];
    if moreInfosState  then
      Result:= thisIdlClass.Name
    else
      Result:= TypeClass2Basic[tc]
  end;
end;


procedure convertToGridValue(valProp: Variant; gridLine: TStrings; storeTypeString: Boolean);
var
  s1, s2: String;
begin
  displayValue(valProp, s2, s1);
  if storeTypeString  then   gridLine.Strings[1]:= s1;
  if s1 = XrayMstring  then
    if (Length(s2) > maxStringLengthInGrid)
      or (Pos(#10, s2) > 0) or (Pos(#13, s2) > 0) or (Pos(#9, s2) > 0) then
      gridLine.Strings[2]:= mess304   // texte non affichable dans l'onglet Proprits
    else
      gridLine.Strings[2]:= s2
  else
    gridLine.Strings[2]:= s2;
end;



{ --------------------------------------------------------------------------- }


procedure TxrayForm3.Display(thisArray: Variant; currObjPath: String);
var
  x, xMin, xMax: Integer;  v2: Variant;
begin
  thisArray2:= thisArray;
  ObjPath.Text:= currObjPath;
  xMin:= VarArrayLowBound(thisArray, 1);    indexMin.Text:= IntToStr(xMin);
  xMax:= VarArrayHighBound(thisArray, 1);   indexMax.Text:= IntToStr(xMax);
  with arrayGrid     do begin
    RowCount:= xMax +2;
    Cells[0, 0]:= mess300;  Cells[1, 0]:= mess301;   Cells[2, 0]:= mess302;
    for x:= xMin to xMax do begin
      v2:= thisArray[x];   convertToGridValue(v2, Rows[x+1], True);
      Cells[0, x +1]:= IntToStr(x);
    end;
  end;
  displayed:= True; ShowModal; displayed:= False;
end;


procedure TxrayForm3.arrayGridDblClick(Sender: TObject);
var
  typeStr, elementText, idx, newObjPath: String;  objX2: Variant;  y: Integer;
begin
  y:= arrayGrid.Selection.Top;  typeStr:= arrayGrid.Cells[1, y];
  idx:= arrayGrid.Cells[0, y];
  newObjPath:= ObjPath.Text +'[' +idx +']';
  if typeStr = XrayMstring then begin
    elementText:= thisArray2[StrToInt(idx)];
    if elementText = '' then
      MessageDlg(mess305, mtInformation, [mbOK], 0)
    else
      xrayForm2.Display(elementText, newObjPath);
  end else if typeStr = XrayMarray  then begin
    objX2:= thisArray2[StrToInt(idx)];
    // analyser le nouvel Array obtenu
    with TxrayForm3.Create(self)  do begin
      Display(objX2, newObjPath); Free;
    end;
  end else if (typeStr = XrayMobject) or (typeStr = XrayMstruct) then begin
    objX2:= thisArray2[StrToInt(idx)];
    // analyser le nouvel objet obtenu
    with TxrayForm1.Create(self)  do begin
      retrieveInfos(objX2, newObjPath);     ShowModal;   Free;
    end;
  end;
end;

procedure TxrayForm3.XrayBtnClick(Sender: TObject);
begin
  arrayGridDblClick(Sender);
end;


end.
