unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Variants;

type
  TForm1 = class(TForm)
    OpenOfficeBtn: TButton;
    BitBtn1: TBitBtn;
    Memo1: TMemo;
    OpenDialog1: TOpenDialog;
    WorkDirBtn: TButton;
    procedure OpenOfficeBtnClick(Sender: TObject);
    procedure WorkDirBtnClick(Sender: TObject);
  private
    { Dclarations prives}
  public
    { Dclarations publiques}
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Uses ComObj, OOoTools, OOoConstants, OOoXray, OOoExamples;


procedure TForm1.OpenOfficeBtnClick(Sender: TObject);
var
  PropFich, monDocument: Variant; monFich: String;
begin

  ConnectOpenOffice; // tablir la connexion, si pas dj fait

  if not OpenDialog1.Execute then exit;
  monFich:= convertToURL(OpenDialog1.FileName);
  if MessageDlg('Rendre visible le document ?',
                  mtConfirmation, [mbYes, mbNo], 0) = mrYes  then
    PropFich:= dummyArray  // tableau null ( aucune option particulire )
  else
    PropFich:= CreateProperties(['Hidden', True]); // ici les noms de proprits sont sensibles  la casse

  try
    monDocument:= StarDesktop.LoadComponentFromURL(monFich, '_blank', 0, PropFich);
  except
    MessageDlg('Document non trouv ou protg par un mot de passe', mtError, [mbOK], 0);
    exit;
  end;
  Memo1.Lines.Add('Ouverture de : ' + ExtractFileName(OpenDialog1.FileName));

  { --------- essayez ici vos instructions OpenOffice.org -------------
              voyez dans OOoExamples des codages typiques
              certaines routines sont appelables depuis cette unit           }

  printDocInfo(monDocument, Memo1);
  Memo1.Lines.Add('Appel de Xray');   Xray(monDocument);

  ShowMessage('Fin du traitement');
  // monDocument.store;
  monDocument.Close(True);
  Memo1.Lines.Add('Document ferm');
end;




procedure TForm1.WorkDirBtnClick(Sender: TObject);
begin
  ConnectOpenOffice; // tablir la connexion, si pas dj fait
  // utilisation d'une routine OOoExamples
  Memo1.Lines.Add('Rpertoire de travail = ' +repertoireTravail)
end;

end.
