unit makeConst;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, FileCtrl;

type
  TForm1 = class(TForm)
    CloseBtn: TBitBtn;
    SDKversion: TEdit;
    Label1: TLabel;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    Label2: TLabel;
    SaveDialog1: TSaveDialog;
    Memo1: TMemo;
    Label3: TLabel;
    GoBtn: TBitBtn;
    procedure GoBtnClick(Sender: TObject);
  private
    { Dclarations prives}
    idl_file, K_file: TStringList;
    nbrScanned, nbrConst, nbrEnum : Integer;
    procedure ScanIdl(unFich : String);
  public
    { Dclarations publiques}
  end;

var
  Form1: TForm1;


{
This unit is part of a toolbox to pilot OpenOffice.org from Delphi using COM Automation.
Copyright (C) 2004  Bernard Marcelly
This unit is free software; you can redistribute it and/or modify it under the terms of
the GNU Lesser General Public License as published by the Free Software Foundation;
either version 2.1 of the License, or (at your option) any later version.
This library is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Lesser General Public License for more details.
You should have received a copy of the GNU Lesser General Public License along with this
library; if not, write to the Free Software Foundation, Inc.,
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}


implementation

{$R *.DFM}

{ la structure des constantes et numration de l'IDL est dcrite dans le
  Developer's Guide section 4.2.1, paragraphe Predefining Values  }

const
  specialChars = [';',  ',',  '+',  '-',  '*',  '/',  '{',  '}',  '=',
                  '%',  '|',  '^',  '&',  '~',  '>',  '<' ];

  startFlag = '_'; // squence initiale pour chaque nom de constante, vite des collisions
  levelSeparator = ''; // pour sparer ventuellement les niveaux com, sun, star, etc.



function fileNameOnly(pathFile: String) : String;
var
  fn, ext : String;
begin
  fn:= ExtractFileName(pathFile);  ext:= ExtractFileExt(pathFile);
  Result:= Copy(fn, 1, Length(fn) - Length(ext));
end;




procedure TForm1.ScanIdl(unFich : String);
var
  ligne, texteUtile, prefixe, groupe, syntx: String;

  procedure reportError(diag: String);
  begin
    Memo1.Lines.Add('Erreur : ' + diag + ' - - ' + unFich);
  end;

  function buildPrefix: Boolean;
  const
    comsunstar = '\idl\com\sun\star\';
  var
    e1: Integer; p: String;
  begin
    p:= ExtractFilePath(unFich);   e1:= Pos(comsunstar, p);
    if e1 > 0 then begin
      e1:= e1 +Length(comsunstar); Delete(p, 1, e1 -1);
      prefixe:= startFlag + StringReplace(p, '\', levelSeparator, [rfReplaceAll]);
      Result:= True;
    end else
      Result:= False; // l'exploration est en dehors de l'arbre des idl
  end;

  function getValue(vstr: String) : String;
  begin
    Result:= StringReplace(vstr, '0x', '$', [rfIgnoreCase]);
    if not (Result[1] in ['0'..'9', '$'])  then
      Result:= prefixe + groupe + levelSeparator + Result; { constante dfinie  partir d'une prcdente }
  end;

  function operatorOK : Boolean;
  begin
    Result:= True;
    if syntx = '+'  then exit;
    if syntx = '-'  then exit;
    if syntx = '*'  then exit;
    if syntx = '/'  then exit;
    if syntx = '%'  then begin syntx:= ' mod ';  exit;  end;
    if syntx = '|'  then begin syntx:= ' or ';   exit;  end;
    if syntx = '^'  then begin syntx:= ' xor ';  exit;  end;
    if syntx = '&'  then begin syntx:= ' and ';  exit;  end;
    if syntx = '~'  then begin syntx:= ' not ';  exit;  end;
    if syntx = '>>' then begin syntx:= ' shr ';  exit;  end;
    if syntx = '<<' then begin syntx:= ' shl ';  exit;  end;
    { ici : erreur de structure }
    reportError('Operator');   texteUtile:= '';  Result:= False;
  end;


  function getNextWord: String;
  var
    d: Integer; sch: char;
  begin
    Result:= '';  texteUtile:= TrimLeft(texteUtile);
    if Length(texteUtile) = 0  then begin
      reportError('getNextWord1');      exit;  { problme de structure }
    end;
    if texteUtile[1] in specialChars  then begin
      sch:= texteUtile[1];
      if sch in ['>', '<'] then  { ces oprateurs doivent tre redoubls }
        if sch = texteUtile[2] then begin
          Result:= sch + sch;  Delete(texteUtile, 1, 2);
        end else begin
          reportError('getNextWord3'); texteUtile:= '';     exit;
        end
      else begin
        Result:= sch; Delete(texteUtile, 1, 1);
      end;
    end else begin
      d:= 1;
      while (d <= Length(texteUtile)) and (texteUtile[d] <> ' ')
            and (not (texteUtile[d] in specialChars) )  do
        inc(d);
      if d > Length(texteUtile)  then begin { problme de structure }
        reportError('getNextWord2');  texteUtile:= '';   exit;
      end;
      Result:= Copy(texteUtile, 1, d-1);  Delete(texteUtile, 1, d-1);
    end;
  end;


  procedure ReadConstants;
  const
    kw = 'const ';
  var
    r, poub: String;
  begin
    groupe:= getNextWord;  syntx:= getNextWord;
    if syntx <> '{'  then begin
      reportError('ReadConstants1'); exit; { erreur de structure }
    end;
    syntx:= getNextWord;
    repeat
      if syntx <> 'const' then begin
        reportError('ReadConstants2'); exit; { erreur de structure }
      end;
      poub:= getNextWord;     { type de la constante, non utilis }
      if LowerCase(poub) = 'unsigned' then poub:= getNextWord; { entier non sign }
      r:= '  ' + prefixe + groupe + levelSeparator + getNextWord; { nom de la constante }
      syntx:= getNextWord;     { signe = }
      if syntx <> '=' then begin
        reportError('ReadConstants3'); exit; { erreur de structure }
      end;
      r:= r + ' = ';  syntx:= getnextWord;
      if (syntx <> '-') and (syntx <> '+')  then begin { on a une valeur }
        r:= r + getValue(syntx);  syntx:= getNextWord;
      end;
      while syntx <> ';'  do begin { expression arithmtique }
        if not operatorOK then exit; { erreur de structure }
        r:= r + syntx + getValue(getNextWord);  syntx:= getNextWord;
      end;
      K_file.Add( r + ';'); inc(nbrConst);  syntx:= getNextWord;
    until syntx = '}';
  end;

  procedure ReadEnums;
  var
    enu, currEnu, previousEnu, r: String;
  begin
    groupe:= getNextWord;
    syntx:= getNextWord; { vrifier le dbut de l'numration }
    if syntx <> '{'  then begin
      reportError('ReadEnums1');  exit;  { problme de structure }
    end;
    previousEnu:= ''; enu:= getNextWord;
    while enu <> '}'  do begin
      inc(nbrEnum); currEnu:= prefixe + groupe + levelSeparator + enu;
      r:= '   ' + currEnu + ' = ';
      enu:= getNextWord; { attention : une enum peut avoir un seul terme !! }
      if (enu = ',') or (enu = '}')  then begin
        if previousEnu = '' then
          K_file.Add( r + '0;')
        else
          K_file.Add( r + previousEnu + ' +1;');
        previousEnu:= currEnu;
        if enu <> '}' then enu:= getNextWord;
      end else if enu = '=' then begin  { enum dclare en constante (obsolte mais accept }
        syntx:= getnextWord;
        if (syntx <> '-') and (syntx <> '+')  then begin { on a une valeur }
          r:= r + getValue(syntx);  syntx:= getNextWord;
        end;
        while (syntx <> ',') and (syntx <> '}')  do begin { expression arithmtique }
          if not operatorOK then exit; { erreur de structure }
          r:= r + syntx + getValue(getNextWord);  syntx:= getNextWord;
        end;
        K_file.Add( r + ';');  previousEnu:= currEnu;  enu:= syntx;
        if enu = ',' then  enu:= getNextWord;
      end;
    end;
    if previousEnu = ''  then reportError('ReadEnums2');    { problme de structure }
  end;

const
  kwConsts = ' constants ';  kwEnums = ' enum ';
var
  dansCommentaire: Boolean;  x, y, nln: Integer;
begin { ---------- TForm1.ScanIdl --------- }
  if not buildPrefix then exit;
  idl_file.LoadFromFile(unFich); // lire tout le fichier, une ligne par String
  texteUtile:= ''; dansCommentaire:= false;
  for nln:= 0 to idl_file.Count -1 do begin { lire le texte et supprimer les commentaires }
    ligne:= idl_file.Strings[nln];
    while Length(ligne) > 0 do
      if dansCommentaire then begin
        x:= Pos('*/', ligne);
        if x > 0 then begin
          Delete(ligne, 1, x+1); { supprimer la fin du commentaire }
          dansCommentaire:= false;
        end else
          ligne:= ''; { toute la ligne est du commentaire }
      end else begin
        x:= Pos('/*', ligne); y:= Pos('//', ligne);
        if ((x > 0) and (y = 0)) or ((x > 0) and (y > x))  then begin
          dansCommentaire:= true;
          texteUtile:= texteUtile + Copy(ligne, 1, x-1) + ' ';
          Delete(ligne, 1, x+1); { supprimer partie analyse }
        end else
          if ((x = 0) and (y > 0)) or ((x > y) and (y > 0))  then begin
            texteUtile:= texteUtile + Copy(ligne, 1, y-1) + ' ';
            ligne:= ''; { le reste de la ligne est du commentaire }
          end else begin
            texteUtile:= texteUtile + ligne + ' ';
            ligne:= ''; { la ligne est analyse}
          end;
      end;
  end;
  texteUtile:= StringReplace(texteUtile, chr(9), ' ', [rfReplaceAll]);
  texteUtile:= StringReplace(texteUtile, chr(10), ' ', [rfReplaceAll]);
  texteUtile:= StringReplace(texteUtile, chr(13), ' ', [rfReplaceAll]);
  while Length(texteUtile) > 0 do begin
    x:= Pos(kwConsts, LowerCase(texteUtile));
    if x > 0 then begin
      Delete(texteUtile, 1, x + Length(kwConsts) -1);    ReadConstants;
    end;
    y:= Pos(kwEnums, LowerCase(texteUtile));
    if y > 0 then begin
      Delete(texteUtile, 1, y + Length(kwEnums) -1);     ReadEnums;
    end;
    if x+y = 0  then texteUtile:= '';
  end;
end;

procedure TForm1.GoBtnClick(Sender: TObject);

  procedure ExploreTree(startDir : String);
  var
    SearchRec: TSearchRec; f: Integer;
  begin
    f:= FindFirst(startDir +'\*.idl', faArchive, SearchRec);
    While f = 0  do begin  // analyser chaque fichier
      ScanIdl(startDir +'\' +SearchRec.Name);
      inc(nbrScanned);  Application.ProcessMessages;    f:= FindNext(SearchRec);
    end;
    FindClose(SearchRec);
    f:= FindFirst(startDir +'\*', faDirectory, SearchRec);
    While f = 0  do begin  // explorer chaque sous-rpertoire
      if ((SearchRec.Attr and faDirectory) > 0) and (SearchRec.Name <> '.')
          and (SearchRec.Name <> '..')  then
        ExploreTree(startDir +'\' +SearchRec.Name); // rcursion
      f:= FindNext(SearchRec);
    end;
    FindClose(SearchRec);
  end;

begin { -------- TForm1.GoBtnClick ------- }
  if Length(SDKversion.Text) = 0 then begin
    MessageDlg('Indiquez la version du SDK utilise', mtError, [mbOK], 0);
    exit;
  end;
  if not SaveDialog1.Execute then exit;
  nbrScanned:= 0;  nbrConst:= 0;  nbrEnum:= 0;
  idl_file:= TStringList.Create;  K_file:= TStringList.Create;
  With Memo1.Lines do begin
    Clear;
    Add('Chemin du fichier  crer :');  Add('  ' + SaveDialog1.FileName);
    Add('Rpertoire racine des IDL du SDK :');  Add(DirectoryListBox1.Directory);
    Add('Version du SDK utilise :');  Add('  ' + SDKversion.Text);
    Add('');
    Screen.Cursor:= crHourglass;
    try
      K_file.Add( 'unit ' + fileNameOnly(SaveDialog1.FileName) +';');
      K_file.Add('');  K_file.Add( 'interface');
      K_file.Add('');  K_file.Add( 'const');
      K_file.Add( '  OOo_SDKversion = ' +'''' +SDKversion.Text +''';');
        ExploreTree(DirectoryListBox1.Directory);
      K_file.Add('');  K_file.Add( 'implementation');
      K_file.Add('');  K_file.Add( 'end.');
      K_file.SaveToFile(SaveDialog1.FileName);
    finally
       Screen.Cursor:= crDefault;
    end;
    Add('');
    Add('Nombre de fichiers explors : ' + IntToStr(nbrScanned));
    Add('Nombre de constantes : '        + IntToStr(nbrConst));
    Add('Nombre d''numrations : '      + IntToStr(nbrEnum));
  end;
  idl_file.Free;  K_file.Free;
end;

end.
