unit OOoExamples;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Variants;

  { cette unit est seulement une collection d'exemples }

function  repertoireTravail: String;
procedure verifInterfaces(monDocument: Variant);   // pour un document Writer
procedure ecrireTexte(monDocument: Variant);  // pour un document Writer
procedure printDocInfo(monDocument: Variant; monMemo: TMemo);  // pour un document existant OpenOffice.org
procedure definirTabulations(monDocument: Variant);  // pour un document Writer
procedure exempleDispatcheur;  // pour un document Writer  ouvert Visible
procedure afficherFeuille(monDocument: Variant);   // pour un document Calc
procedure borduresCellule(monDocument: Variant);   // pour un document Calc
procedure dessinerPolygone(monDocument: Variant); // pour un document Draw, Impress ou Calc


implementation

Uses ComObj, OOoTools, OOoConstants, OOoXray;


{ ------------- exemples pour information seulement -------------- }

procedure ouvrirDocument1;  // pas d'option d'ouverture
var
  monFich: String; monDocument: Variant;
begin
  monFich:= convertToURL('c:\Docs OpenOffice\TestDelphi.sxw');
  try
    monDocument:= StarDesktop.LoadComponentFromURL(monFich, '_blank', 0, dummyArray);
  except
    MessageDlg('Document non trouv ou protg par un mot de passe', mtError, [mbOK], 0);
    exit;
  end;
end;


procedure ouvrirDocument2;  // ouvrir cach et avec un mot de passe
var
  PropFich, monDocument: Variant;  monFich: String;
begin
  monFich:= convertToURL('c:\Docs OpenOffice\TestDelphi.sxw');
  { attention : ici les noms de proprit sont sensibles  la casse }
  PropFich:= CreateProperties(['Hidden', True, 'Password', 'tatata']);
  try
    monDocument:= StarDesktop.LoadComponentFromURL(monFich, '_blank', 0, PropFich);
  except
    MessageDlg('Document non trouv ou protg par un mot de passe', mtError, [mbOK], 0);
    exit;
  end;
end;


procedure ouvrirDocument3; // crer un nouveau document
var
  monFich: String; monDocument: Variant;
begin
  monFich:= 'private:factory/scalc';  // nouveau document Calc
  try
    monDocument:= StarDesktop.LoadComponentFromURL(monFich, '_blank', 0, dummyArray);
  except
    MessageDlg('Document non trouv ou protg par un mot de passe', mtError, [mbOK], 0);
    exit;
  end;
end;


procedure fermerDocument1;  // document existant, dj stock auparavant
var
  monDocument: Variant;
begin
  if monDocument.isModified then      monDocument.store;
  monDocument.close(True);
end;


procedure fermerDocument2;  // nouveau document
var
  monDocument: Variant; monFich: String;
begin
  monFich:= convertToURL('C:\Docs OpenOffice\toto.sxc');
  monDocument.storeAsURL(monFich, dummyArray);
  monDocument.close(True);
end;


{ ---------- routines utilisables depuis Unit1 -------------------- }


function  repertoireTravail: String;
var
  sv, w: Variant;
begin
  // ce service est indpendant de tout document
  sv:= CreateUnoService('com.sun.star.util.PathSettings');
  w:= sv.Work;  // obtenir le rpertoire de travail
  repertoireTravail:= convertFromURL(w);
end;


procedure verifInterfaces(monDocument: Variant);   // pour un document Writer
var
  vd: Variant;
begin
  vd:= monDocument.getViewData;
  if HasUnoInterfaces(vd, ['com.sun.star.container.XIndexContainer', 'com.sun.star.lang.XServiceInfo', 'com.sun.star.container.XIndexAccess']) then
    showMessage('OK')
  else
    showMessage('Non!');

  if HasUnoInterfaces(vd, ['com.sun.star.container.XindexContainer']) then
    showMessage('OK')
  else
    showMessage('Non!');
end;


procedure ecrireTexte(monDocument: Variant);  // pour un document Writer
var
  monTexte, monCurseur : Variant;  letexte : String; laCouleur : Longword;
const
  paragr= _textControlCharacterPARAGRAPH_BREAK; // constante de OOoConstants
begin
  monTexte:= monDocument.Text;
  monCurseur:= monTexte.createTextCursor;
  monCurseur.gotoNextParagraph(False);
  monCurseur.gotonextparagraph(False); // les noms de methodes sont insensibles  la casse
  monCurseur.gotoNextParagraph(False);
  monCurseur.gotoNextParagraph(True); // slectionner un paragraphe
  letexte:= monCurseur.String; // utilisation de la pseudo-proprit String
  ShowMessage(letexte);
  monCurseur.setString('Bonjour'); // utilisation de la mthode  la place de la pseudo-proprit String
  monCurseur.CharColor:= RGB(0,255,0);  // couleur verte
  monCurseur.goLeft(1, false);
  monCurseur.collapseToEnd;
  laCouleur:= monCurseur.charcolor; // les noms de proprits sont insensibles  la casse
  ShowMessage('Couleur ' +IntToStr(laCouleur));
  monTexte.insertControlCharacter(monCurseur, paragr, false); // ajout paragraphe
  monTexte.insertString(monCurseur, 'Termin', false);  // ajout d'un texte
end;



procedure printDocInfo(monDocument: Variant; monMemo: TMemo);  // pour un document existant OpenOffice.org
var
  docInfo, uneDate: Variant;  v: Array[1..7] of Integer;
begin
  docInfo:= monDocument.DocumentInfo;  // docInfo est une structure
  uneDate:= docInfo.CreationDate;  // uneDate est une structure
  v[1]:= uneDate.Day;
  v[2]:= uneDate.Month;
  v[3]:= uneDate.Year;
  v[4]:= uneDate.Hours;
  v[5]:= uneDate.Minutes;
  v[6]:= uneDate.Seconds;
  v[7]:= uneDate.HundredthSeconds;
  with monMemo.Lines do begin
    Add(Format('Date de cration : %d/%d/%d  %2dh%2dmn%2ds  %3dms',
      [v[1],v[2],v[3],v[4],v[5],v[6], v[7]*10]));
    Add('Auteur : ' + docInfo.Author);
    Add('N de rvision : ' + IntToStr(docInfo.EditingCycles));
  end;
end;



procedure definirTabulations(monDocument: Variant);  // pour un document Writer
var
  monTexte, monCurseur, ListeTaquets: Variant;  Texte1: String;
const
  Tab = #9;
begin
  // cration et remplissage d'un tableau de structures
  monTexte:= monDocument.Text;
  monCurseur:= monTexte.createTextCursor;
  monCurseur.gotoNextParagraph(false); //sauter le titre
  // mettre 3 taquets sur le paragraphe en cours
  ListeTaquets:= CreateUnoStruct('com.sun.star.style.TabStop', 2);
  ListeTaquets[0].DecimalChar:= ',';
  ListeTaquets[0].FillChar:= ' ';
  ListeTaquets[0].Position:= 2500; // 25 mm ( 2,5 cm )
  ListeTaquets[0].Alignment:= _styleTabAlignLEFT;
  ListeTaquets[1].DecimalChar:= ',';
  ListeTaquets[1].FillChar:= ' ';
  ListeTaquets[1].Position:= 4700; // 47 mm
  ListeTaquets[1].Alignment:= _styleTabAlignCENTER;
  ListeTaquets[2].DecimalChar:= ',';
  ListeTaquets[2].FillChar:= ' ';
  ListeTaquets[2].Position:= 7010; // 70,1 mm
  ListeTaquets[2].Alignment:= _styleTabAlignRIGHT;
  monCurseur.ParaTabStops:= ListeTaquets;
  // utiliser ces tabulations
  Texte1:= 'Dbut' + Tab + 'Tab0' + Tab + 'Tab1' + Tab + 'Tab2' +Tab;
  monTexte.insertString( monCurseur, Texte1, false);
end;



procedure exempleDispatcheur;  // pour un document Writer  ouvert Visible
var
  props: Variant;
begin
  {     ***  rechercher le mot : blabla  ***

  cette liste d'arguments est l'quivalent du codage ralis par l'enregistreur de macros  }
  props:= CreateProperties([
    'SearchItem.StyleFamily', 2,
    'SearchItem.CellType', 0,
    'SearchItem.RowDirection', True,
    'SearchItem.AllTables', false,
    'SearchItem.Backward', false,
    'SearchItem.Pattern', false,
    'SearchItem.Content', false,
    'SearchItem.AsianOptions', false,
    'SearchItem.AlgorithmType', 0,
    'SearchItem.SearchFlags', 65552,
    'SearchItem.SearchString', 'blabla',   // le mot  rechercher
    'SearchItem.ReplaceString', '',
    'SearchItem.Locale', 255,
    'SearchItem.ChangedChars', 2,
    'SearchItem.DeletedChars', 2,
    'SearchItem.InsertedChars', 2,
    'SearchItem.TransliterateFlags', 1024,
    'SearchItem.Command', 0,
    'Quiet', true             ]);
  execDispatch('.uno:ExecuteSearch', props);
  // le mot trouv doit tre slectionn dans le document
end;



procedure afficherFeuille(monDocument: Variant);   // pour un document Calc
var
  lesFeuilles, uneFeuille: Variant;   listage, nomf: String;  x: Integer;
begin
  lesFeuilles:= monDocument.Sheets;
  listage:= 'Liste des feuilles :';
  for x:= 0 to lesFeuilles.Count -1  do begin  // balayage d'une collection
     uneFeuille:= lesFeuilles.getByIndex(x);
     listage:= listage + chr(13) + uneFeuille.Name;
  end;
  showMessage(listage);

  // pour cette partie le document doit tre visible
  repeat
    uneFeuille:= monDocument.currentController.activeSheet;
    nomf:= InputBox('Rendre active une feuille', 'Nom de la feuille ?', uneFeuille.Name);
  until lesFeuilles.hasByName(nomf);    // recherche dans une collection nomme
  uneFeuille:= lesFeuilles.getByName(nomf);
  monDocument.currentController.activeSheet:= uneFeuille; // modifier un sous.sous.objet
end;


procedure borduresCellule(monDocument: Variant);   // pour un document Calc
var
  lesFeuilles, maFeuille, maCellule, unBord: Variant;
begin
  lesFeuilles:= monDocument.Sheets;
  maFeuille:= lesFeuilles.getByIndex(2);  // troisime feuille du tableaur
  maCellule:= maFeuille.getCellRangeByName('C2');
  { il faut crer une nouvelle structure pour chaque bord,
    sinon les quatre bordures vont pointer sur la mme structure }
  unBord:= CreateUnoStruct('com.sun.star.table.BorderLine');
  unBord.Color:= RGB(200,0,0);
  unBord.OuterLineWidth:= 30;
  maCellule.LeftBorder:= unBord; // ligne simple, rouge
  unBord:= CreateUnoStruct('com.sun.star.table.BorderLine');
  unBord.Color:= RGB(200,0,0);
  unBord.OuterLineWidth:= 100;
  maCellule.RightBorder:= unBord; // ligne simple, rouge
  unBord:= CreateUnoStruct('com.sun.star.table.BorderLine');
  unBord.Color:= RGB(0,120,0);
  unBord.OuterLineWidth:= 100;
  unBord.InnerLineWidth:= 60;
  unBord.LineDistance:= 30;
  maCellule.TopBorder:= unBord; // ligne double, verte
  unBord:= CreateUnoStruct('com.sun.star.table.BorderLine');
  unBord.Color:= RGB(0,0,120);
  unBord.OuterLineWidth:= 100;
  unBord.InnerLineWidth:= 60;
  unBord.LineDistance:= 30;
  maCellule.BottomBorder:= unBord; // ligne double, bleue
end;



procedure dessinerPolygone(monDocument: Variant); // pour un document Draw, Impress ou Calc
var
  maPage, maForme, lesPoints: Variant;
begin
  maPage:= monDocument.DrawPages.getByIndex(0);
  { invoquer un service   partir d'un objet }
  maForme:= monDocument.createInstance('com.sun.star.drawing.PolyLineShape');
  { cration et remplissage d'un tableau de structures
    et utilisation pour remplir une proprit }
  lesPoints:=  CreateUnoStruct('com.sun.star.awt.Point', 3);
  lesPoints[0].X:= 4000;   lesPoints[0].Y:= 2000;
  lesPoints[1].X:= 4500;   lesPoints[1].Y:= 5000;
  lesPoints[2].X:= 11500;  lesPoints[2].Y:= 8000;
  lesPoints[3].X:= 6000;   lesPoints[3].Y:= 11000;
  maPage.add(maForme);
  maForme.LineWidth:= 100;    maForme.LineColor:= RGB(50, 200, 200);
  { VarArrayOf sert  obtenir un tableau de polygones, ici avec un seul polygone }
  maForme.PolyPolygon:= VarArrayOf([lesPoints]);
end;






end.