unit OOoXray;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, Grids, ExtCtrls;

type
  TxrayForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    propGrid: TStringGrid;
    TabSheet2: TTabSheet;
    methGrid: TStringGrid;
    TabSheet3: TTabSheet;
    serviceGrid: TStringGrid;
    TabSheet5: TTabSheet;
    Memo1: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    ExitBtn: TBitBtn;
    ImplementName: TEdit;
    searchAPIBtn: TBitBtn;
    SaveBtn: TBitBtn;
    SaveDialog1: TSaveDialog;
    XrayBtn: TBitBtn;
    ObjectPath: TEdit;
    Label2: TLabel;
    TabSheet4: TTabSheet;
    interfaceGrid: TStringGrid;
    procedure methGridDblClick(Sender: TObject);
    procedure propGridDblClick(Sender: TObject);
    procedure searchAPIBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure XrayBtnClick(Sender: TObject);
    procedure propGridContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure methGridContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
  private
    { Dclarations prives }
    thisObject: Variant;
    unePageSDK, bkLines: TStringList;
    function  objectIsStructure: Boolean;
    procedure extractProperties;
    procedure extractMethods;
    procedure extractSupportedServices;
    procedure extractAvailableServices;
    procedure extractInterfaces;
    procedure displayAPIpage(laPage: String; item: String= '');
    procedure findPropertyBookmarks(searchName: String);
    procedure XrayAgain(objName, ObjPath: String; nameIsProperty: Boolean);
  public
    { Dclarations publiques }
    procedure retrieveInfos(ObjX: Variant; ObjXname: String);
  end;

var
  xrayForm1: TxrayForm1;

procedure xray(myObject: Variant);


{
This unit is part of a toolbox to pilot OpenOffice.org from Delphi using COM Automation.
Copyright (C) 2004  Bernard Marcelly
This library is free software; you can redistribute it and/or modify it under the terms of
the GNU Lesser General Public License as published by the Free Software Foundation;
either version 2.1 of the License, or (at your option) any later version.
This library is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Lesser General Public License for more details.
You should have received a copy of the GNU Lesser General Public License along with this
library; if not, write to the Free Software Foundation, Inc.,
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}


implementation

{$R *.dfm}

uses StrUtils, ShellAPI, OOoTools, OOoConstants, OOoXray2, OOoXray3;


const //  adapter selon votre SDK et vos besoins
  SDKaddr= 'C:\OpenOffice.org1.1_SDK\docs\common\ref\';
  useDefaultBrowser= False; // false permet d'afficher un item de la page SDK
  myBrowser = 'C:\Program Files\Opera7\Opera.exe';

const // textes de messages
  mess01= 'Ceci est un objet Null';  mess02= 'Ceci est un tableau Null';
  mess04= 'Valeur = ';
  mess10= '- Proprits -';  mess10T= '- Proprits tries -';
  mess11= '- Type -';   mess12= '- Valeur -';  mess13= '- Remarques -';
  mess20= '- Mthodes -';  mess20T= '- Mthodes tries -';
  mess21= '- Arguments -';  mess22= '- Type Retour -';  mess23= '- Interface -';
  mess30= '- Services supports, tris -';
  mess31= '- Services disponibles, tris -';
  mess32= '- Interfaces supportes, tries -';
  mess40= '*** objet sans nom ***';
  mess50= 'may be Void';  mess51= 'read only';  mess52= 'write only';
  mess60= 'pseudo-prop';
  mess61= '???';
  mess62= 'Structure :  ';
  mess70= 'Xray impossible car la mthode ncessite des arguments';
  mess71= 'Cette mthode ne renvoie rien';
  mess72= 'Limitation du pont COM : %s est inaccessible';
  mess73= 'Chane de caractres de longueur nulle';
  mess80= 'Dsol, la page de SDK n''existe pas.';
  mess81= 'Dsol, cette pseudo-proprit est non documente';
  mess82= 'Pseudo-proprit, affichage de : %s';
  mess83= 'Il existe plusieurs pages sur : %s';


  { -------------------------------------------------- }


function isValidObject(myObject: Variant; ObjXname: String): Boolean;
var
  strV2, typeV2: String;
begin
  Result:= False;
  if isNullEmpty(myObject) then
    MessageDlg(mess01, mtInformation, [mbOK], 0)
  else if VarIsArray(myObject) and (VarArrayHighBound(myObject, 1) < 0) then
    MessageDlg(mess02, mtInformation, [mbOK], 0)   // Null Array
  else begin
    displayValue(myObject, strV2, typeV2);
    if (typeV2 = XrayMstruct) or (typeV2 = XrayMobject) then
      Result:= True
    else if typeV2 = XrayMstring then
      if strV2 = '' then
        MessageDlg(mess73, mtInformation, [mbOK], 0)
      else
        xrayForm2.Display(strV2, ObjXname)
    else if typeV2 = XrayMarray then
      if xrayForm3.displayed then // prendre une autre instance
        with TxrayForm3.Create(nil)  do begin
          Display(myObject, ObjXname);   Free;
        end
      else
        xrayForm3.Display(myObject, ObjXname)
    else
      MessageDlg(mess04 +strV2, mtInformation, [mbOK], 0);
  end;
end;


procedure xray(myObject: Variant);
begin
  if isValidObject(myObject, XrayMobject)  then
    with xrayForm1  do begin
      retrieveInfos(myObject, XrayMobject);     ShowModal;
    end;
end;



{  --------------  TxrayForm1  ---------------------- }


procedure TxrayForm1.XrayAgain(objName, ObjPath: String; nameIsProperty: Boolean);
var
  insp, info2, objX2, unElem, classeIDL: Variant;
begin
  insp:= OOoIntrospection.inspect(thisObject);
  try  // certaines proprits et mthodes ne sont pas accessibles par le pont COM
    if nameIsProperty  then
      if insp.hasMethod('getPropertyValue', -1) then
          objX2:= thisObject.getPropertyValue(objName) // peut dclencher une exception
      else begin
        classeIDL:= OOoReflection.getType(thisObject);
        unElem:= classeIDL.getField(objName);    objX2:= unElem.get(thisObject);
      end
    else begin
      info2:= insp.getMethod(objName ,-1);
      objX2:= info2.invoke(thisObject, dummyArray); // peut dclencher une exception
    end;
    // analyser le nouvel objet obtenu
    if isValidObject(objX2, ObjPath)  then
      with TxrayForm1.Create(self)  do begin
        retrieveInfos(objX2, ObjPath);     ShowModal;   Free;
      end;
  except // getPropertyValue a probablement dclench une exception 'Le type ne correspond pas'
    MessageDlg(Format(mess72, [objName]), mtInformation, [mbOK], 0);
  end
end;



procedure TxrayForm1.retrieveInfos(ObjX: Variant; ObjXname: String);

  procedure clearInfosDisplay;
  begin
    with propGrid     do begin
      RowCount:= 2; // au moins deux lignes pour que la premire puisse tre fixe
      Cells[0, 0]:= mess10;   Cells[1, 0]:= mess11;
      Cells[2, 0]:= mess12;   Cells[3, 0]:= mess13;
    end;
    with methGrid     do begin
      RowCount:= 2;
      Cells[0, 0]:= mess20;   Cells[1, 0]:= mess21;
      Cells[2, 0]:= mess22;   Cells[3, 0]:= mess23;
    end;
  end;

begin { -------- TxrayForm1.retrieveInfos -------- }
  thisObject:= Objx;
  clearInfosDisplay;
  ObjectPath.Text:= ObjXname;
  ImplementName.Text:= mess40; // valeur par dfaut
  { les mthodes doivent tre appeles dans cet ordre }
  if not objectIsStructure  then extractProperties;
  extractMethods;
  extractSupportedServices;
  extractAvailableServices;
  extractInterfaces;
  if propGrid.Cols[0].IndexOf('ImplementationName') >= 0 then
    ImplementName.Text:= thisObject.ImplementationName;
end;


procedure TxrayForm1.extractProperties;

  function addAfter(existingText, moreText: String): String;
  begin  // ajoute un texte aprs un texte existant, en le sparant
    if existingText = '' then
      Result:= moreText
    else
      Result:= existingText + ' - ' + moreText;
  end;

  function isPseudoProperty(gridLine: TStrings; insp: Variant): Boolean;
  var
    info2, info3, valProp: Variant;
    propReadable: Boolean;
  begin
    Result:= False;
    with gridLine  do
      if insp.hasMethod('get' +Strings[0], -1)  then begin
        Result:= True;  Strings[3]:= mess60;   // pseudo-prop
        if not insp.hasMethod('set' +Strings[0], -1)  then
          Strings[3]:= addAfter(Strings[3], mess51);   // read only
        info2:= insp.getMethod('get' +Strings[0] ,-1);
        info3:= info2.ReturnType;
        Strings[1]:= getShortTypeStr(info3, propReadable);
        if propReadable then
          try  // certaines mthodes ne sont pas accessibles par le pont COM
            valProp:= info2.invoke(thisObject, dummyArray);
            convertToGridValue(valProp, gridLine, False);  // ne pas modifier la case type
          except // invoke a probablement dclench une exception 'Le type ne correspond pas'
            Strings[2]:= mess61;
          end;
      end else
        if insp.hasMethod('set' +Strings[0], -1)  then begin  // write only
          Strings[1]:= '';   Strings[2]:= '';
          Strings[3]:=  mess60 +' - ' +mess52;      Result:= True;
        end;
  end;

var
  insp, info1, info2, propSetInfo, valProp: Variant;
  x, xMax: Integer;  exists_getPropertyValue: Boolean;
begin  { ------- TxrayForm1.extractProperties ------}
  insp:= OOoIntrospection.inspect(thisObject);
  exists_getPropertyValue:= insp.hasMethod('getPropertyValue', -1);
  if exists_getPropertyValue  then   propSetInfo:= thisObject.PropertySetInfo;
  info1:= insp.getProperties(-1);   xMax:= VarArrayHighBound(info1, 1);
  if xMax >= 0 then propGrid.RowCount:= xMax +2;
  for x:= 0 to xMax do begin // balayer la liste des proprits
    info2:= info1[x];
    with propGrid.Rows[x +1] do begin
      Strings[0]:= info2.Name;  Strings[3]:= '';
      if isPseudoProperty(propGrid.Rows[x +1], insp) then  Continue;
      if (info2.Attributes and _beansPropertyAttributeMAYBEVOID) <> 0  then
        Strings[3]:= mess50;
      if (info2.Attributes and _beansPropertyAttributeREADONLY) <> 0  then
        Strings[3]:= addAfter(Strings[3], mess51);
      if exists_getPropertyValue then
        if propSetInfo.hasPropertyByName(Strings[0])  then
            try  // certaines proprits ne sont pas accessibles par le pont COM
              valProp:= thisObject.getPropertyValue(Strings[0]);
              convertToGridValue(valProp, propGrid.Rows[x +1], True);
            except // getPropertyValue a probablement dclench une exception 'Le type ne correspond pas'
              Strings[1]:= mess61;   Strings[2]:= mess61;
            end;
    end;
  end;
end;


function  TxrayForm1.objectIsStructure: Boolean;
var
  classeIDL, elemList, elemX, elemVal: Variant;
  x, xMax, accMode: Integer;   s1, s2, s3: String;
begin
  classeIDL:= OOoReflection.getType(thisObject);
  Result:= (classeIDL.TypeClass = _unoTypeClassSTRUCT);
  if not Result  then exit;  // objet ou tableau, ou type simple, etc
  ImplementName.Text:= mess62 + classeIDL.Name;  // nom de la structure
  elemList:= classeIDL.Fields;
  xMax:= VarArrayHighBound(elemList, 1);
  if xMax >= 0 then propGrid.RowCount:= xMax +2;
  for x:= 0 to xMax do begin // balayer la liste des lments de la structure
    elemX:= elemList[x];

    with propGrid.Rows[x +1] do begin
      Strings[0]:= elemX.Name;
      accMode:= elemX.AccessMode;
      if accMode = _reflectionFieldAccessModeWRITEONLY  then begin
        s1:= '';  s2:= '';  s3:= mess52;
      end else begin
        if accMode = _reflectionFieldAccessModeREADONLY  then s3:= mess51  else s3:= '';
        try  // certains lments ne sont pas accessibles par le pont COM
          elemVal:= elemX.get(thisObject);   displayValue(elemVal, s2, s1);
        except // get a probablement dclench une exception 'Le type ne correspond pas'
          s1:= mess61;   s2:= mess61;  s3:= '';
        end;
      end;
      Strings[1]:= s1;       Strings[2]:= s2;    Strings[3]:= s3;
    end;
  end;
end;


procedure TxrayForm1.extractMethods;
var
  insp, info1, info2, info3, infoParam, paramType: Variant;
  x, y, xMax: Integer;  listeParams: String; dummy: Boolean;

begin
  insp:= OOoIntrospection.inspect(thisObject);
  info1:= insp.getMethods(-1);
  xMax:= VarArrayHighBound(info1, 1);
  if xMax >= 0 then     methGrid.RowCount:= xMax +2;
  for x:= 0 to xMax do begin   // chaque mthode
    info2:= info1[x];
    with methGrid.Rows[x +1] do begin
      Strings[0]:= info2.Name;
      info3:= info2.ReturnType;
      Strings[2]:= getShortTypeStr(info3, dummy);
      if Strings[2] = 'void'  then Strings[2]:= '';
      info3:= info2.ParameterInfos;  listeParams:= '';
      for y:= 0 to VarArrayHighBound(info3, 1) do begin //   chaque paramtre de la mthode
        infoParam:= info3[y];  paramType:= infoParam.aType;
        if listeParams <> '' then listeParams:= listeParams + ' ;  ';
        listeParams:= listeParams + infoParam.aName +' : ' + getShortTypeStr(paramType, dummy);
      end;
      Strings[1]:= listeParams;
      info3:= info2.DeclaringClass; Strings[3]:= info3.Name;
    end;
  end;
end;


procedure TxrayForm1.extractSupportedServices;
var
  lesServices: Variant;  x, Xm: Integer;  triage: TStringList;
begin
  triage:= TStringList.Create;
  with triage do begin  // trier la liste des services
    Duplicates:= dupIgnore;  CaseSensitive:= True;  Sorted:= True;  Add(mess30);
    if propGrid.Cols[0].IndexOf('SupportedServiceNames') >= 0  then begin
      lesServices:=  thisObject.SupportedServiceNames;
      Xm:= VarArrayHighBound(lesServices, 1); // Xm = -1 si aucun service
      for x:= 0 to Xm do   Add(lesServices[x]);
    end;
    if Count > serviceGrid.RowCount  then  serviceGrid.RowCount:= Count;
  end;
  serviceGrid.Cols[0].Assign(triage);  triage.Free;
end;


procedure TxrayForm1.extractAvailableServices;
var
  lesServices: Variant;  x, Xm: Integer;  triage: TStringList;
begin
  triage:= TStringList.Create;
  with triage do begin  // trier la liste des services
    Duplicates:= dupIgnore;  CaseSensitive:= True;  Sorted:= True;  Add(mess31);
    if propGrid.Cols[0].IndexOf('AvailableServiceNames') >= 0  then begin
      lesServices:=  thisObject.AvailableServiceNames;
      Xm:= VarArrayHighBound(lesServices, 1); // Xm = -1 si aucun service
      for x:= 0 to Xm do   Add(lesServices[x]);
    end;
    if Count > serviceGrid.RowCount  then  serviceGrid.RowCount:= Count;
  end;
  serviceGrid.Cols[1].Assign(triage);  triage.Free;
end;


procedure TxrayForm1.extractInterfaces;
var
  y: Integer; interf: String;  triage: TStringList;
begin
  triage:= TStringList.Create;
  with triage do begin  // trier la liste des interfaces
    Duplicates:= dupIgnore;  CaseSensitive:= True;  Sorted:= True;  Add(mess32);
    // rcuprer les interfaces listes avec les mthodes
    for y:= 1 to methGrid.RowCount -1  do begin
      interf:= methGrid.Cells[3, y];
      if interf <> '' then  Add(interf);  // triage limine les doublons
    end;
    if Count > interfaceGrid.RowCount  then  interfaceGrid.RowCount:= Count;
  end;
  interfaceGrid.Cols[0].Assign(triage);  triage.Free;
end;


procedure TxrayForm1.methGridDblClick(Sender: TObject);
var
  y: Integer;   methodName, resultType: String;
begin
  y:= methGrid.Selection.Top;    methodName:= methGrid.Cells[0, y];
  if methodName = ''  then  exit;            // ligne vide
  resultType:= methGrid.Cells[2, y];
  if resultType = ''  then
   MessageDlg(mess71, mtInformation, [mbOK], 0)  // la mthode ne renvoie pas de rsultat
  else  if (resultType ='type') or (resultType ='[]type') then
    MessageDlg(Format(mess72, [methodName]), mtInformation, [mbOK], 0)  // impossible d'obtenir un type par COM
  else  if methGrid.Cells[1, y] <> '' then
      MessageDlg(mess70, mtInformation, [mbOK], 0)  // xray impossible, la mthode emploie des arguments
    else
      XrayAgain(methodName, ObjectPath.Text +'.' + methodName, False);
end;



procedure TxrayForm1.propGridDblClick(Sender: TObject);

  procedure displayFullText(propName, path2, propComments: String);
  var
    insp, info2, classeIDL: Variant;  propText: String;
  begin
    if Pos(mess60, propComments) > 0  then begin // pseudo-proprit
      insp:= OOoIntrospection.inspect(thisObject);
      info2:= insp.getMethod('get' +propName ,-1);
      propText:= info2.invoke(thisObject, dummyArray);
    end else  if Pos(mess62, ImplementName.Text) = 1  then begin //structure
      classeIDL:= OOoReflection.getType(thisObject);
      info2:= classeIDL.getField(propName);
      propText:= info2.get(thisObject);
    end else     // vraie proprit
      propText:= thisObject.getPropertyValue(propName);
      
    xrayForm2.Display(propText, path2);
  end;


var
  propType, propName, path2: String;  y: Integer;
begin  { --------- TxrayForm1.propGridDblClick ---------}
  y:= propGrid.Selection.Top;
  propName:= propGrid.Cells[0, y];  propType:= propGrid.Cells[1, y];
  path2:= ObjectPath.Text +'.' +propName; // chemin de l'lment dans l'objet
  if propType = XrayMstring then begin
    if propGrid.Cells[2, y] = '' then
      MessageDlg(mess73, mtInformation, [mbOK], 0)
    else
      displayFullText(propName, path2, propGrid.Cells[3, y]);

  end else  if (propType ='type') or (propType ='[]type') then // impossible d'obtenir un type par COM
    MessageDlg(Format(mess72, [propName]), mtInformation, [mbOK], 0)

  else  if Pos(mess60, propGrid.Cells[3, y]) = 0  then begin// vraie proprit
    if (propType = XrayMobject) or (propType = XrayMstruct) or (propType = XrayMarray)  then
      XrayAgain(propName, path2, True);

  end else  if Pos(mess52, propGrid.Cells[3, y]) = 0  then   // pseudo-proprit
      XrayAgain('get' +propName, path2, False);  // pas write only, la mthode getXXX existe
end;



procedure TxrayForm1.displayAPIpage(laPage: String; item: String= '');
var
  pSDK: String;
begin
  if laPage = '' then exit;
  pSDK:= StringReplace(laPage, '.', '\', [rfReplaceAll]);
  pSDK:= SDKaddr + pSDK +'.html';
  if FileExists(pSDK) then
    if useDefaultBrowser then
      ShellExecute(0, 'open', PChar(pSDK), nil, nil, SW_SHOW)
    else
      ShellExecute(0, 'open', PChar(myBrowser), PChar(pSDK +'#' +item), nil, SW_SHOW)
  else
    MessageDlg(mess80, mtInformation, [mbOK], 0);  // page inexistante
end;



procedure TxrayForm1.findPropertyBookmarks(searchName: String);

  function validContext(SDKindexLine: String) : Boolean;
  const
    sv2= 'com/sun/star/'; sv3= '.html';
  var
    x2: Integer; nsv2: String;
  begin
    Result:= false;  x2:= Pos(sv2, SDKindexLine);   if x2=0 then exit;
    nsv2:= Copy(SDKindexLine, x2, 1000);
    x2:= Pos(sv3, nsv2);  Delete(nsv2, x2, 1000);    // isoler le nom du service
    nsv2:= StringReplace(nsv2, '/', '.', [rfReplaceAll]);
    x2:= serviceGrid.Cols[0].IndexOf(nsv2);  // rechercher dans les services supports
    Result:= (x2 >= 0);
  end;

  procedure displayPage(htmlLine: String);
  const
    mark1= '<dt><a href="../';  mark2= '.html';
  var
    pageAddr: String;
  begin
    pageAddr:= Copy(htmlLine, Pos(mark1, htmlLine) +Length(mark1), 1000);
    Delete(pageAddr, Pos(mark2, pageAddr), 1000);
    pageAddr:= StringReplace(pageAddr, '/', '\', [rfReplaceAll]);
    displayAPIpage(pageAddr, searchName);
  end;

  procedure createThenDisplayPage(searchName: String);
  Const
    myPage1 = '<html> <head> <title>Xray results</title> <base href="';
    myPage2 = '"> </head> <body> <h3> ';
    myPage3 = '</h3> <dl> ';
    myPage4 = '</dl> </body> </html>';
  var
    pageRelais: TStringList;  tempFilesPath, myTempFile: String;
  begin
    pageRelais:= TStringList.Create;
    pageRelais.Add(myPage1 +convertToURL(SDKaddr +'index-files\')
      +myPage2 +Format(mess83, [searchName]) +myPage3);
    pageRelais.AddStrings(bkLines);
    pageRelais.Add(myPage4);
    tempFilesPath:= GetEnvironmentVariable('TMP');
    if tempFilesPath = '' then tempFilesPath:= GetEnvironmentVariable('TEMP');
    myTempFile:= tempFilesPath +'\XrayResults.html';
    pageRelais.SaveToFile(myTempFile);
    pageRelais.Free;
    if useDefaultBrowser then
      ShellExecute(0, 'open', PChar(myTempFile), nil, nil, SW_SHOW)
    else
      ShellExecute(0, 'open', PChar(myBrowser), PChar(myTempFile), nil, SW_SHOW)
  end;

var
  oneLine, htmlName, docAddr: String; w: Integer;
begin  { ----------- TxrayForm1.findPropertyBookmarks ----------- }
  docAddr:= SDKaddr +'index-files/index-'
            +IntToStr(ord(UpCase(searchName[1])) -ord('A') +1) +'.html';
  unePageSDK:= TStringList.Create;  bkLines:= TStringList.Create;
  unePageSDK.LoadFromFile(docAddr);
  htmlName:= '<b>' + searchName + '</b></a> - property';
  for w:= 0 to unePageSDK.Count -1 do begin // rechercher le service support ayant cette proprit
    oneLine:= unePageSDK.Strings[w];
    if AnsiContainsText(oneLine, htmlName) and validContext(oneLine)  then
      bkLines.Add(oneLine);
  end;
  if bkLines.Count = 0 then begin  // rechercher un service quelconque ayant cette proprit
    for w:= 0 to unePageSDK.Count -1 do begin
      oneLine:= unePageSDK.Strings[w];
      if AnsiContainsText(oneLine, htmlName)  then
        bkLines.Add(oneLine);
    end;
  end;
  if bkLines.Count = 0  then
    MessageDlg(mess80, mtInformation, [mbOK], 0)  // page non trouve
  else if bkLines.Count = 1  then  // trouv LA page du SDK
    displayPage(bkLines.Strings[0])
  else  // trouv plusieurs pages du SDK
    createThenDisplayPage(searchName);
  unePageSDK.Free;  bkLines.Free;
end;



procedure TxrayForm1.searchAPIBtnClick(Sender: TObject);
var
  x, y, y2: Integer; methodName, propName, getsetp, structName: String;
begin  { --------------- TxrayForm1.searchAPIBtnClick ------------------}
  if Pos(mess62, ImplementName.Text) = 1  then begin
    structName:= MidStr(ImplementName.Text, Length(mess62) +1, 200);
    displayAPIpage(structName);    exit;
  end;
  Case PageControl1.ActivePageIndex of
  0: begin // proprit
      y:= propGrid.Selection.Top;  propName:= propGrid.Cells[0,y];
      if Pos(mess60, propGrid.Cells[3, y]) > 0 then begin // pseudo-proprit
        y2:= methGrid.Cols[0].IndexOf('get' +propName);
        if y2 < 0 then  begin
          y2:= methGrid.Cols[0].IndexOf('set' +propName);
          if y2 < 0 then begin
            MessageDlg(mess81, mtInformation, [mbOK], 0);  // impossible de trouver la pseudo-prop
            exit;
          end else
            getsetp:= 'set' +propName;
        end else
          if methGrid.Cols[0].IndexOf('set' +propName) > 0 then
              getsetp:= 'get' +propName + ' / set' +propName
            else
              getsetp:= 'get' +propName;

        MessageDlg(Format(mess82, [getsetp]), mtInformation, [mbOK], 0);
        methodName:= methGrid.Cells[0, y2];
        displayAPIpage(methGrid.Cells[3, y2], methodName);
      end else
        findPropertyBookmarks(propName);
    end;
  1: begin; // mthodes - > page interface
      y:= methGrid.Selection.Top;
      methodName:= methGrid.Cells[0,y];
      displayAPIpage(methGrid.Cells[3, y], methodName);
    end;
  2: begin // service
      x:= serviceGrid.Selection.Left;  y:= serviceGrid.Selection.Top;
      displayAPIpage(serviceGrid.Cells[x,y]);
    end;
  3: begin // interface
      x:= interfaceGrid.Selection.Left;  y:= interfaceGrid.Selection.Top;
      displayAPIpage(interfaceGrid.Cells[x,y]);
    end;
  end;
end;



procedure TxrayForm1.SaveBtnClick(Sender: TObject);

  procedure writeCalcPage(oneGrid: TStringGrid; mySheet: Variant; sheetName: String);
  var
    x, y: Integer;  oneCol: TStrings;   myColumn, firstLine, myCell: Variant;
  begin
    { cette routine crit environ 400 cellules par seconde (Win XP, Athlon XP 1800+)
          une version similaire en OOoBasic s'excute moins vite         }
    mySheet.Name:= sheetName;
    firstLine:= mySheet.Rows.getByIndex(0);
    firstLine.CharWeight:= _awtFontWeightBOLD;
    firstLine.CellBackColor:= RGB(100, 255, 255);
    for x:= 0 to oneGrid.ColCount -1 do begin
      oneCol:= oneGrid.Cols[x];
      for y:= 0 to oneCol.Count -1 do
        if oneCol.Strings[y] <> '' then begin
          myCell:= mySheet.getCellByPosition(x, y);
          myCell.String:= oneCol.Strings[y];
        end;
        myColumn:= mySheet.Columns.getByIndex(x);
        myColumn.OptimalWidth:= true; // ajuster la largeur de la colonne
        Application.ProcessMessages;
    end;
  end;

var
  fileAddress: String;  myDoc, allSheets, loadProp: Variant;
begin  { ---------  TxrayForm1.SaveBtnClick --------- }
  if not SaveDialog1.Execute then exit;
  Screen.Cursor:= crHourglass;       Application.ProcessMessages;
  try
    fileAddress:= 'private:factory/scalc';   // nouveau document Calc
    loadProp:= CreateProperties(['Hidden', true]);
    myDoc:= StarDesktop.LoadComponentFromURL(fileAddress, '_blank', 0, loadProp);
    // un nouveau document Calc comporte 3 feuilles
    allSheets:= myDoc.Sheets;
    writeCalcPage(propGrid,    allSheets.getByIndex(0), 'Props');
    writeCalcPage(methGrid,    allSheets.getByIndex(1), 'Meths');
    writeCalcPage(serviceGrid, allSheets.getByIndex(2), 'ServIntf');
    fileAddress:= convertToURL(SaveDialog1.FileName);
    myDoc.storeAsURL(fileAddress, dummyArray);
    myDoc.close(True);
  finally
    Screen.Cursor:= crDefault;
  end;
end;

procedure TxrayForm1.XrayBtnClick(Sender: TObject);
begin
  Case PageControl1.ActivePageIndex of
  0 : propGridDblClick(Sender);
  1 : methGridDblClick(Sender);
  end;
end;

procedure TxrayForm1.propGridContextPopup(Sender: TObject;
  MousePos: TPoint; var Handled: Boolean);
var
  y: Integer; triage, newRow: TStringList; aLine: String;
begin
  if propGrid.Tag <> 0  then begin
    propGrid.RowCount:= 2;   propGrid.Rows[1].Clear;
    if not objectIsStructure  then extractProperties;
    propGrid.Cells[0,0]:= mess10;   propGrid.Tag:= 0;  // proprits non tries
  end else begin
    triage:= TStringList.Create;  newRow:= TStringList.Create;
    with triage do begin  // trier la liste des interfaces
      Duplicates:= dupIgnore;  CaseSensitive:= True;  Sorted:= True;
      for y:= 0 to propGrid.RowCount-1 do begin
        aLine:= propGrid.Rows[y].Text;   Add(aLine);
      end;
      for y:= 0 to Count -1 do begin
        newRow.Text:= Strings[y];   propGrid.Rows[y].Assign(newRow);
        newRow.Clear;
      end;
    end;
    propGrid.Cells[0,0]:= mess10T;   propGrid.Tag:= 1; // proprits tries
    triage.Free;  newRow.Free;
  end;
end;

procedure TxrayForm1.methGridContextPopup(Sender: TObject;
  MousePos: TPoint; var Handled: Boolean);
var
  y: Integer; triage, newRow: TStringList; aLine: String;
begin
  if methGrid.Tag <> 0  then begin
    methGrid.RowCount:= 2;   methGrid.Rows[1].Clear;    extractMethods;
    methGrid.Cells[0,0]:= mess20;   methGrid.Tag:= 0;  // proprits non tries
  end else begin
    triage:= TStringList.Create;  newRow:= TStringList.Create;
    with triage do begin  // trier la liste des interfaces
      Duplicates:= dupIgnore;  CaseSensitive:= True;  Sorted:= True;
      for y:= 0 to methGrid.RowCount-1 do begin
        aLine:= methGrid.Rows[y].Text;   Add(aLine);
      end;
      for y:= 0 to Count -1 do begin
        newRow.Text:= Strings[y];  methGrid.Rows[y].Assign(newRow);
        newRow.Clear;
      end;
    end;
    methGrid.Cells[0,0]:= mess20T;   methGrid.Tag:= 1; // proprits tries
    triage.Free;  newRow.Free;
  end;
end;



end.
