/*
 This module is part of a toolbox to pilot OpenOffice.org from VBScript using COM Automation.
     Copyright (C) 2007  Bernard Marcelly
 This unit is free software; you can redistribute it and/or modify it under the terms of
 the GNU Lesser General Public License as published by the Free Software Foundation;
 either version 2.1 of the License, or (at your option) any later version.
 This library is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY;
 without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU Lesser General Public License for more details.
 You should have received a copy of the GNU Lesser General Public License along with this
 library; if not, write to the Free Software Foundation, Inc.,
 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


var OpenOffice = null;
var StarDesktop, OOoIntrospection, OOoDisp;



function isNullEmpty(thisVariant)
{
  if (thisVariant==null)
    return true;

  switch (typeof(thisVariant)) // order of tests is important
  {
  case "undefined":
    return true; break;
  case "object":
  case "function":
    return false; break;
  default:
    return isNaN(thisVariant);
  };
}

function CreateUnoService(serviceName)
{ // quivalent de la fonction OOoBasic  / equivalent to OOoBasic function
  var Result;

  Result = OpenOffice.createInstance(serviceName);
  if (isNullEmpty(Result))
    throw OOo_serviceKO + serviceName;
  return Result;
}

function isOpenOfficeConnected()
{
  var DeskTopbis, Result;
  
  if (isNullEmpty(OpenOffice))
    return false;
  try
  {
    DeskTopbis = OpenOffice.createInstance("com.sun.star.frame.Desktop");
    DeskTopbis = null;
    return true;
  }
  catch(e)
  {
    OpenOffice = null;
    return false;
  }
}

function ConnectOpenOffice()
{
  if (isOpenOfficeConnected())
    return;
  try
  {
    OpenOffice = new ActiveXObject("com.sun.star.ServiceManager");
  }
  catch(e)
  {
    OpenOffice = null;
  }

  if (isNullEmpty(OpenOffice))
    throw OOo_connectKO;
  else
  {
    StarDesktop = CreateUnoService("com.sun.star.frame.Desktop");
    OOoIntrospection = CreateUnoService("com.sun.star.beans.Introspection");
    OOoDisp = CreateUnoService("com.sun.star.frame.DispatchHelper");
  };
}

function DisconnectOpenOffice(closeOpenOffice)
{
  OOoIntrospection = null;
  OOoDisp = null;
  OpenOffice = null;
  if (closeOpenOffice==true)
    StarDesktop.terminate();

  StarDesktop = null;
}

function dummyArray()
{ /* cre un tableau vide, pour une liste vide
     creates an empty array for an empty list  */
  return new Array();
}

function CreateUnoStruct(structName, indexMax)
{ /* quivalent de la fonction OOoBasic  / equivalent to OOoBasic function
    indexMax = -1 returns a Uno structure
    indexMax >= 0 returns an array of Uno structure          */
  try 
  {
    if (indexMax < 0)
      return OpenOffice.Bridge_GetStruct(structName);
    else
    {
      var d;
      var Result = new Array(indexMax+1);
      for (d = 0; d <= indexMax; d++)
      { 
        Result[d] = OpenOffice.Bridge_GetStruct(structName);
      }
    }
  }
  catch(e)
  {
    throw OOo_structureKO + structName;
  }

  return Result;
}

function MakePropertyValue(PropName, PropValue)
{ // quivalent de la fonction de Danny Brewer / equivalent to Danny Brewer's function
  var Result;

  Result = OpenOffice.Bridge_GetStruct("com.sun.star.beans.PropertyValue");
  Result.Name = PropName;
  Result.Value = PropValue;
  return Result;
}


function CreateProperties(propertyList)
{ // fonction plus puissante que MakePropertyValue  /  function more powerful than MakePropertyValue
  var x, xMax, y, Result;

  xMax = propertyList.length -1;
  if (((xMax & 1) == 0) || (xMax < 1))
    throw OOo_nbrArgsKO;
  else
  {
    Result = new Array((xMax + 1) >> 1);
    x = 0;    y = 0;
    do
    {
      Result[y] = OpenOffice.Bridge_GetStruct("com.sun.star.beans.PropertyValue");
      if (typeof(propertyList[x]) != "string")
        throw OOo_argRank + x + OOo_notString;
      else
        Result[y].Name = propertyList[x];

      Result[y].Value = propertyList[x + 1];
      y = y + 1;      x = x + 2;
    }
    while (x <= xMax);
    return Result;
  }
}



function HasUnoInterfaces(thisObject, interfaceList)
{ // quivalent de la fonction OOoBasic  / equivalent to OOoBasic function
  var x, xMax, y, oneInterf;
  var insp, info1, info2, info3;
  var intfExists = new Array(interfaceList.length); // each element is : undefined

  try
  {
    insp = OOoIntrospection.inspect(thisObject);
    info1 = insp.getMethods(-1);    info1 = info1.toArray();
  }
  catch(e)
  {
    throw OOo_inspectionKO;
  };

  for (y = 0; y < info1.length; y++) // scan all methods of the Uno object
  {
    try
    {
      info2 = info1[y];
      info3 = info2.DeclaringClass;
    }
    catch(e)
    {
      throw OOo_inspectionKO;
    }
    oneInterf = info3.Name;
    for (x = 0; x < interfaceList.length; x++)
    {
      if (oneInterf == interfaceList[x])
        intfExists[x] = true;
    }
  };
  for (x = 0; x < intfExists.length; x++) // check that all interfaces requested are available
  {
    oneInterf = intfExists[x];
    if (typeof(oneInterf) == "undefined")
      return false;
  };
  return true;
}


function execDispatch(slotName, params)
{
  OOoDisp.executeDispatch(StarDesktop.CurrentFrame, slotName, "", 0, params);
}

function copyToClipboard()
{
  execDispatch(".uno:Copy", dummyArray);
}

function pasteFromClipboard()
{
  execDispatch(".uno:Paste", dummyArray);
}


function ConvertToURL(winAddr)
{ // quivalent de la fonction OOoBasic  / equivalent to OOoBasic function
  var slow, prefix, UTF8Addr;
  var x;
  var URLprefix, sv;

  URLprefix = new Array("file:///", "ftp://", "news:", "http://", "mailto:", "macro:", "private:");
  slow = winAddr.toLowerCase(); prefix = "";
  for (x = 0; x < URLprefix.length; x++)
  {
    if (slow.indexOf(URLprefix[x]) == 0)
    {
      winAddr = winAddr.substr(URLprefix[x].length);
      if (x > 0)  // prefix file:/// is useless
        prefix = URLprefix[x];
    };
  };
  if ((prefix.length == 0) & (slow.indexOf("@") >= 0))
    return "mailto:" + winAddr;
  else
  {
    sv = CreateUnoService("com.sun.star.ucb.FileContentProvider");
    UTF8Addr = sv.getFileURLFromSystemPath("", winAddr);
    if (UTF8Addr.length == 0)
      throw OOo_convertToURLKO;

    return prefix + UTF8Addr;
  }
}

function ConvertFromURL(URLaddr)
{ // quivalent de la fonction OOoBasic  / equivalent to OOoBasic function
  var slow, prefix, winAddr, x;
  var URLprefix, sv, re;

  URLprefix = new Array("file:///", "ftp://", "news:", "http://", "mailto:", "macro:", "private:");
  slow = URLaddr.toLowerCase();  prefix = "";
  for (x = 0; x < URLprefix.length; x++)
  {
    if (slow.indexOf(URLprefix[x]) == 0)
    {
      if (x > 0)
      {
        URLaddr = URLaddr.substr(URLprefix[x].length);
        prefix = URLprefix[x];
      };
      break;
    };
  };
  sv = CreateUnoService("com.sun.star.ucb.FileContentProvider");
  winAddr = sv.getSystemPathFromFileURL(URLaddr);
  if (prefix.length > 0) // backslash only with file:///
  {
    re = /\\/g;  // regular expression
    winAddr = winAddr.replace(re, "/");
  };

  if (winAddr.length == 0)
    throw OOo_convertFromURLKO;

  return prefix + winAddr;
}




function OOoRGB(redV, greenV, blueV)
{ /* quivalent de la fonction OOoBasic : RGB()   ne pas utiliser RGB() de JScript
    equivalent to OOoBasic function : RGB()       do not use RGB() from JScript        */
  return ((redV & 255) << 16) + ((greenV & 255) << 8) + (blueV & 255);
}

function Blue(colorOOo)
{ // quivalent de la fonction OOoBasic  / equivalent to OOoBasic function
  return colorOOo & 255;
}

function Green(colorOOo)
{ // quivalent de la fonction OOoBasic  / equivalent to OOoBasic function
  return (colorOOo >> 8) & 255;
}

function Red(colorOOo)
{ // quivalent de la fonction OOoBasic  / equivalent to OOoBasic function
  return (colorOOo >> 16) & 255;
}


function runBasicMacro(macroName, argsList, docName)
{ /* macroName : Library.Module.Macro
     argsList = "" if no arguments
     docName = "" if the macro is in My Macros or in OpenOffice.org Macros  */

  execDispatch("macro://" + docName + "/" + macroName + "(" + argsList + ")", dummyArray);
  /* si la macro n'existe pas la routine s'excute sans erreur
     if the macro does not exist the routine runs without error    */
}


function runScript(scriptName, argsList, language, location)
{
  var mspf, scriptPro, xScript;

  if ((language == "Basic") & (location == "user"))
    location = "application";

  mspf = CreateUnoService("com.sun.star.script.provider.MasterScriptProviderFactory");
  scriptPro = mspf.createScriptProvider("");
  xScript = scriptPro.getScript("vnd.sun.star.script:" + scriptName + 
               "?language=" + language + "&location=" + location);
  return xScript.Invoke(argsList, dummyArray, dummyArray);
}

function xray(myObject)
{ /* vous devez avoir install Xray dans OpenOffice
     you must have installed Xray in OpenOffice     */
  var arg1 = new Array(1);

  arg1[0] = myObject;
  runScript("XrayTool._Main.Xray", arg1, "Basic", "application", false);
}



