
/* ---------- exemples divers , faire ConnectOpenOffice avant de les appeler ----------------
   ---------- various examples , ConnectOpenOffice before calling them ------------------- */



function HelloWorldExample()
{
  var myDoc, myText, myCursor;
  myDoc = StarDesktop.loadComponentFromURL("private:factory/swriter", "_blank", 0, dummyArray);
  myText = myDoc.Text;
  myCursor = myText.createTextCursor();
  myText.insertString(myCursor, OOoMess111, false);
  // inserting a paragraph break, using an API constant
  myText.insertControlCharacter(myCursor, OOOtextControlCharacterPARAGRAPH_BREAK, false);
  myCursor.CharColor = OOoRGB(0, 200, 0);
  myText.insertString(myCursor, OOoMess112, false);
  myCursor.CharWeight = OOOawtFontWeightBOLD; // an API constant
  myText.insertString(myCursor, OOoMess113, false);
  myCursor.CharColor = -1;
  myCursor.CharWeight = OOOawtFontWeightNORMAL // an API constant
  myText.insertControlCharacter(myCursor, OOOtextControlCharacterPARAGRAPH_BREAK, false);
  ShowMsg(OOoMess105);
  myDoc.close(true);
}


function showWorkDirectory()
{ /* cette routine est indpendante de tout document
  elle affiche l'adresse du rpertoire de travail indiqu dans la configuration d'OpenOffice

  this routine is independent from any document
  it displays the work directory indicated in the configuration of OpenOffice   */

  var sv, w;
  sv = CreateUnoService("com.sun.star.util.PathSettings");
  w = sv.Work;
  ShowMsg(ConvertFromURL(w));
}


function defineTabulations()
{
  var myDoc, myText, myCursor, tabStopsList, Texte1;
  
  myDoc = StarDesktop.loadComponentFromURL("private:factory/swriter", "_blank", 0, dummyArray);
  myText = myDoc.Text;
  myCursor = myText.createTextCursor();
  /* cration et remplissage d'un tableau de structures Uno
     create and fill an array of Uno structures             */
  tabStopsList = CreateUnoStruct("com.sun.star.style.TabStop", 2);
  /* mettre 3 taquets sur le paragraphe en cours
     put 3 tab stops on the current paragraph   */
  tabStopsList[0].DecimalChar = ",";
  tabStopsList[0].FillChar = " ";
  tabStopsList[0].Position = 2500; // 25 mm ( 2,5 cm )
  tabStopsList[0].Alignment = OOOstyleTabAlignLEFT;
  tabStopsList[1].DecimalChar = ",";
  tabStopsList[1].FillChar = " ";
  tabStopsList[1].Position = 4700 // 47 mm
  tabStopsList[1].Alignment = OOOstyleTabAlignCENTER;
  tabStopsList[2].DecimalChar = ",";
  tabStopsList[2].FillChar = " ";
  tabStopsList[2].Position = 7010; // 70,1 mm
  tabStopsList[2].Alignment = OOOstyleTabAlignRIGHT;
  myCursor.ParaTabStops = tabStopsList;
  /* utiliser ces tabulations
     use these tabulation stops  */
  Texte1 = "Dbut\tTab0\tTab1\tTab2\t";
  myText.insertString(myCursor, Texte1, false);
  myText.insertControlCharacter(myCursor, OOOtextControlCharacterPARAGRAPH_BREAK, false);
  ShowMsg(OOoMess105);
  myDoc.close(true);
}



function CalcSortingExample()
{
  var myDoc, firstSheet, aRange, fields, unoWrap, sortDx, n;
  
  myDoc = StarDesktop.loadComponentFromURL("private:factory/scalc", "_blank", 0, dummyArray);
  firstSheet = myDoc.Sheets.getByIndex(0);
  firstSheet.getCellRangeByName("A1").String = "Texts";
  firstSheet.getCellRangeByName("B1").String = "Values";
  for (n = 1; n < 16; n++)
  {
    firstSheet.getCellByPosition(0, n).String = "Row" + (n+1);
    firstSheet.getCellByPosition(1, n).Value = Math.random( ) * 1000.0;
  }
  ShowMsg(OOoMess107);
  aRange = firstSheet.getCellRangeByName("A1:B16");
  fields = CreateUnoStruct("com.sun.star.table.TableSortField", 0);
  fields[0].Field = 1;
  fields[0].IsAscending = true;
  fields[0].IsCaseSensitive = true;
  
  /* il faut prciser quel type de squence est transmis  la proprit SortFields
     you must specify which type of sequence is transmitted to SortFields property  */
  unoWrap = OpenOffice.Bridge_GetValueObject();
  unoWrap.set("[]com.sun.star.table.TableSortField", fields);
  /* remplissage de SortDescriptor : proprits ayant des valeurs autres que dfaut
     filling of SortDescriptor : properties with non-default values  */
  sortDx = CreateProperties(new Array("ContainsHeader", true, "SortFields", unoWrap));
  
  aRange.sort(sortDx);
  ShowMsg(OOoMess108);
  myDoc.close(true);
}



function setCellBorders()
{
  var myDoc, allSheets, mySheet, myCell, oneBorder;
  
  myDoc = StarDesktop.loadComponentFromURL("private:factory/scalc", "_blank", 0, dummyArray);
  /* un nouveau document Calc a toujours 3 feuilles
     a new Calc document always has 3 sheets       */    
  allSheets = myDoc.Sheets;
  mySheet = allSheets.getByIndex(2);  // third sheet of the spreadsheet
  mySheet.Name = "test";  // change its name
  myCell = mySheet.getCellRangeByName("C2");
  myCell.String = OOoMess111;
  /* il faut crer une nouvelle structure Uno pour chaque bord,
     sinon les quatre bordures vont pointer sur la mme structure Uno   
  
     you must create a new Uno structure for each border
     otherwise all 4 borders will point at the same Uno structure   */
  oneBorder = CreateUnoStruct("com.sun.star.table.BorderLine", -1);
  oneBorder.Color = OOoRGB(200,0,0);
  oneBorder.OuterLineWidth = 30;
  myCell.LeftBorder = oneBorder; // single red line
  oneBorder = CreateUnoStruct("com.sun.star.table.BorderLine", -1);
  oneBorder.Color = OOoRGB(200,0,0);
  oneBorder.OuterLineWidth = 100;
  myCell.RightBorder = oneBorder; // single red line
  oneBorder = CreateUnoStruct("com.sun.star.table.BorderLine", -1)
  oneBorder.Color = OOoRGB(0,120,0);
  oneBorder.OuterLineWidth = 100;
  oneBorder.InnerLineWidth = 60;
  oneBorder.LineDistance = 30;
  myCell.TopBorder = oneBorder; // double green line
  oneBorder = CreateUnoStruct("com.sun.star.table.BorderLine", -1);
  oneBorder.Color = OOoRGB(0,0,120);
  oneBorder.OuterLineWidth = 100;
  oneBorder.InnerLineWidth = 60;
  oneBorder.LineDistance = 30;
  myCell.BottomBorder = oneBorder; // double blue line
  myDoc.CurrentController.ActiveSheet = mySheet;  // show this sheet
  ShowMsg(OOoMess105);
  myDoc.close(true);
}


function useDataArray()
{ /*  exemple lisant et modifiant les cellules d'une zone
      example showing how to read and modify the cells of a zone */

  var zoneAddr = "B2:D5";
  var myDoc, mySheet, cellZone, ra, v, w, c;
  var x, y, xMax, yMax;
  
  myDoc = StarDesktop.loadComponentFromURL("private:factory/scalc", "_blank", 0, dummyArray);
  mySheet = myDoc.Sheets.getByIndex(0);
  ShowMsg(OOoMess109 +zoneAddr);
  cellZone = mySheet.getCellRangebyName(zoneAddr);
  ra = cellZone.RangeAddress;
  xMax = ra.EndColumn -ra.StartColumn;   yMax = ra.EndRow -ra.StartRow;

  v = cellZone.getDataArray();  v = v.toArray();
  for (y=0; y<=yMax; y++)
  {
  /* pour lire ou modifier un lment il faut rcuprer sa ligne
     to read or modify an element you must get its line           */
    w = v[y];   w = w.toArray();
    for (x=0; x<=xMax; x++)
    {
      c = w[x];
      if (typeof(c) == "number")
      { // modify Double value
        w[x] = (10*x +y)*100000 +c;
      }
      else
      { // modify String value
        w[x] = c +" X" +x +"Y" +y;
      };
    };
    v[y] = w;
  };
  cellZone.setDataArray(v);
  ShowMsg(OOoMess105);
  myDoc.close(true);
}


function drawPolygon()
{
  var myDoc, myPage, myDrawing, thePoints;
  
  myDoc = StarDesktop.loadComponentFromURL("private:factory/sdraw", "_blank", 0, dummyArray);
  myPage = myDoc.DrawPages.getByIndex(0);
  /* invoquer un service   partir d"un objet Uno
     invoke a service from a Uno object            */
  myDrawing = myDoc.createInstance("com.sun.star.drawing.PolyLineShape");
  myPage.add(myDrawing);
  myDrawing.LineWidth = 100;   
  myDrawing.LineColor = OOoRGB(50, 200, 200);
  /* crer et remplir un tableau de structures pour l'affecter  une proprit
     create and fill an array of structures to assign it to a property    */
  thePoints =  CreateUnoStruct("com.sun.star.awt.Point", 3);
  thePoints[0].X = 4000;  
  thePoints[0].Y = 2000;
  thePoints[1].X = 4500;
  thePoints[1].Y = 5000;
  thePoints[2].X = 11500;  
  thePoints[2].Y = 8000;
  thePoints[3].X = 6000;  
  thePoints[3].Y = 11000;
  /* Array sert  obtenir un tableau de polygones, ici avec un seul polygone
     Array is used to create an array of polygons, here there is only one polygon  */
  myDrawing.PolyPolygon = new Array(thePoints);
  ShowMsg(OOoMess105);
  myDoc.close(true);
}




/* Ces squences sont  usage interne, mais elles peuvent servir d'exemples
   These sequences are for internal use but may be useful as examples        */
  
function TestSequences()
{
  var  myDoc, v, insp, info2;
  var myTest, c, c2;
  var m, p, p2;

  do
  {
    m = UserInput("Choose a test number", "COM_OOo tests", "0");
    myTest = parseInt(m);
    if (isNaN(myTest))
      myTest = 0;

    switch (myTest) {
    case 1: // get an array of String from a Uno object (more than 800 items)
      v = OpenOffice.getAvailableServiceNames();
      ShowMsg("Index max = " + v.ubound() +  "\n" +  "v(10) = " +  v.toArray()[10] ); break;
    case 2: // Convert to and from URL
      do
      {
        m = UserInput("MS-Windows address", "COM_OOo tests", "");
        if ((m==null) || (m.length == 0))
          break;

        p = ConvertToURL(m);     p2 = ConvertFromURL(p);
        ShowMsg(m +"\n" +p +"\n" +p2 +"\n\nIdentity ? " +  (m==p2));
      }
      while (true);
      break;
    case 3: // color conversions
      do
      {
        m = UserInput("Color value ", "COM_OOo tests", "0");
        c = parseInt(m);
        if (isNaN(c))
          c = 0;
        
        c2 = OOoRGB(Red(c), Green(c), Blue(c));
        ShowMsg("Color : " + c +"\nRed = " + Red(c) 
          + "\nGreen = " + Green(c)  +"\nBlue = " + Blue(c) 
          +"\nOOoRGB(R,G,B) : " + c2 +"\n\nIdentity ? " + (c==c2));
      }
      while (c!=0);
      break;
    case 20: // CreateUnoStruct, one structure
      v = CreateUnoStruct("com.sun.star.table.BorderLine", -1);
      v.Color = 12345;
      ShowMsg("Color : " + v.Color);  break;
    case 21: // CreateUnoStruct, array of structures
      v = CreateUnoStruct("com.sun.star.table.BorderLine", 3);
      c = v.length -1;
      v[0].Color = 54321;      v[c].OuterLineWidth = 147;
      ShowMsg("Index max : " + c +"\nColor : " + v[0].Color 
        +"\nOuterLineWidth : " + v[c].OuterLineWidth);
      break;
    case 30: // MakePropertyValue
      v = MakePropertyValue("Height", 175);
      ShowMsg("Property name : " + v.Name);   break;
    case 40: // CreateProperties
      v = CreateProperties(new Array("Width", 369, "PrintNotes", true, "Title", "Hello"));
      c = v.length -1;
      ShowMsg("Index max : " + c  +"\n" + v[0].Name + " : " + v[0].Value 
          +"\n" + v[1].Name + " : " + v[1].Value +"\n" + v[c].Name + " : " + v[c].Value);
      break;
    };

    if ((myTest >= 100) & (myTest < 200)) //  Writer document is needed
    {
      myDoc = StarDesktop.loadComponentFromURL("private:factory/swriter", "_blank", 0, dummyArray);
      ShowMsg("Document is displayed");
      switch (myTest) {
      case 101: // HasUnoInterfaces
        ShowMsg("All interfaces supported ? " + HasUnoInterfaces(myDoc, 
              new Array("com.sun.star.frame.XStorable", 
              "com.sun.star.style.XAutoStylesSupplier", 
              "com.sun.star.text.XTextGraphicObjectsSupplier")) );
        break;
      case 110: // dispatcher
        v = CreateProperties(new Array("Text", "Hello World !"));
        execDispatch(".uno:InsertText", v);     execDispatch(".uno:InsertPara", dummyArray);
        break;
      case 111: // Clipboard
        ShowMsg("Select something");     copyToClipboard();
        ShowMsg("Put cursor elsewhere") ;  pasteFromClipboard();
        break;
      case 120: // runBasicMacro
        ShowMsg("Manually load the document testScript.odt with macros enabled");
        runBasicMacro("Standard.Module1.convertDevise", "73.5, 6.55957, Euros", "testScript");
        break;
      case 130: 
        runScript("HelloWorld.helloworld.bsh", dummyArray, "BeanShell", "share");
        break;
      case 131: // get returned value from a script
        ShowMsg("Using resident macro : Standard.Testage.MultiplyByPi");
        p = new Array(1);  p[0] = 67;
        v = runScript("Standard.Testage.MultiplyByPi", p, "Basic", "application");
        ShowMsg("Result from macro : " + v);   break;
      case 140:
        xray(myDoc);  break;
      case 150: // checks that print method is not intercepted by the JS interpreter
    	myDoc.print(dummyArray);  break;
      case 151: // check  an empty array
        v = myDoc.TextTables.ElementNames;   v = v.toArray();
        ShowMsg("index max : " + v.length);   break;
      case 152: // check that a Null object is recognized
        var wx1zr;
        ShowMsg("Unassigned variable is Null/Empty ? " + isNullEmpty(wx1zr));
    	v = myDoc.TextTables;
    	ShowMsg("TextTables object is Null/Empty ? " + isNullEmpty(v)); // answer : false
    	v = myDoc.XForms;
    	ShowMsg("XForms object is Null/Empty ? " + isNullEmpty(v));  // answer : true
    	break; 
      case 160: // this may not work if OpenOffice Registry is incorrect
    	insp = OOoIntrospection.inspect(myDoc);
    	info2 = insp.getProperty("ApplyFormDesignMode", -1);
    	v = info2.Type;
    	m = v.Name;  // check that v is a com.sun.star.beans.Property
    	ShowMsg("info2.Type.Name = boolean ? " +  (m=="boolean"))
      };
      
      ShowMsg("Document will close");    myDoc.close(true);
    }
    
  }
  while (myTest != 0);
}
