/*
 * Decompiled with CFR 0.152.
 */
package filterui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class Configuration {
    public static final String PROP_OFFICE_HOST = "office_host";
    public static final String PROP_OFFICE_PORT = "office_port";
    private static final String CONFIGFILE = "config/filterui.ini";
    private Properties m_aSet;

    public Configuration() {
        try {
            this.m_aSet = new Properties();
            this.m_aSet.load(this.getClass().getResourceAsStream(CONFIGFILE));
        }
        catch (FileNotFoundException exNotFound) {
            System.out.println("Configuration::ctor()\n\t" + exNotFound.getMessage());
        }
        catch (IOException exIO) {
            System.out.println("Configuration::ctor()\n\t" + exIO.getMessage());
        }
        catch (Exception ex) {
            System.out.println("Configuration::ctor()\n\t" + ex.getMessage());
        }
    }

    public long getLongProperty(String sKey, long nDefault) {
        long nVal = nDefault;
        try {
            nVal = Long.parseLong(this.m_aSet.getProperty(sKey).trim());
        }
        catch (NumberFormatException exFormat) {
            System.out.println("Configuration::getLongProperty()\n\t" + exFormat.getMessage());
        }
        return nVal;
    }

    public String getStringProperty(String sKey, String sDefault) {
        return this.m_aSet.getProperty(sKey, sDefault);
    }
}

