/*
 * Decompiled with CFR 0.152.
 */
package filterui;

import filterui.RessourceHelper;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FilterQuery
extends JPanel {
    public static final String RESSOURCEFILE = "filterui.res.FilterQuery";
    private static final String RES_TITLE_FACTORIES = "FilterQuery.title_factories";
    private static final String RES_TITLE_FLAGS = "FilterQuery.title_flags";
    private static final String RES_TITLE_SORTING = "FilterQuery.title_sorting";
    private static final String RES_TITLE_ACTIONS = "FilterQuery.title_actions";
    private static final String RES_FACTORY_ALL = "FilterQuery.factory_all";
    private static final String RES_FACTORY_WRITER = "FilterQuery.factory_writer";
    private static final String RES_FACTORY_WRITER_WEB = "FilterQuery.factory_writer_web";
    private static final String RES_FACTORY_WRITER_GLOBAL = "FilterQuery.factory_writer_global";
    private static final String RES_FACTORY_CALC = "FilterQuery.factory_calc";
    private static final String RES_FACTORY_CHART = "FilterQuery.factory_chart";
    private static final String RES_FACTORY_DRAW = "FilterQuery.factory_draw";
    private static final String RES_FACTORY_IMPRESS = "FilterQuery.factory_impress";
    private static final String RES_FACTORY_MATH = "FilterQuery.factory_math";
    private static final String RES_FACTORY_GRAPHICS = "FilterQuery.factory_graphics";
    private static final String RES_FLAGUSING_IFLAGS = "FilterQuery.flagusing_iflags";
    private static final String RES_FLAGUSING_EFLAGS = "FilterQuery.flagusing_eflags";
    private static final String RES_SORT_ASCENDING = "FilterQuery.sort_ascending";
    private static final String RES_SORT_DESCENDING = "FilterQuery.sort_descending";
    private static final String RES_SORT_DEFAULT_FIRST = "FilterQuery.sort_default_first";
    private static final String RES_SORT_USE_ORDER = "FilterQuery.sort_use_order";
    private static final String RES_SORT_CASE_SENSITIVE = "FilterQuery.sort_case_sensitive";
    private static final String RES_SORTPROP_NAME = "FilterQuery.sortprop_name";
    private static final String RES_SORTPROP_UINAME = "FilterQuery.sortprop_uiname";
    private static final String RES_ACTION_QUERY = "FilterQuery.action_query";
    private static final String RES_ACTION_RESET = "FilterQuery.action_reset";
    private static final String ACTIONCOMMAND_QUERY = "query";
    private static final String ACTIONCOMMAND_RESET = "reset";
    private static final String[] ALL_FLAGRES_NAMES = new String[]{"Filter.flag_import", "Filter.flag_export", "Filter.flag_template", "Filter.flag_internal", "Filter.flag_templatepath", "Filter.flag_own", "Filter.flag_alien", "Filter.flag_usesoptions", "Filter.flag_default", "Filter.flag_notinfiledialog", "Filter.flag_notinchooser", "Filter.flag_asynchron", "Filter.flag_readonly", "Filter.flag_notinstalled", "Filter.flag_consultservice", "Filter.flag_3rdpartyfilter", "Filter.flag_packed", "Filter.flag_silentexport", "Filter.flag_browserprefered", "Filter.flag_prefered"};
    Vector m_lChangeListener;
    String m_sQuery;
    JPanel m_paFactories;
    JPanel m_paFlags;
    JPanel m_paSorting;
    JPanel m_paActions;
    JComboBox m_bxFactories;
    JComboBox m_bxSortProps;
    JButton m_btQuery;
    JButton m_btReset;
    JCheckBox m_cbFlagImport;
    JCheckBox m_cbFlagExport;
    JCheckBox m_cbFlagTemplate;
    JCheckBox m_cbFlagIternal;
    JCheckBox m_cbFlagTemplatePath;
    JCheckBox m_cbFlagOwn;
    JCheckBox m_cbFlagAlien;
    JCheckBox m_cbFlagUsesOptions;
    JCheckBox m_cbFlagDefault;
    JCheckBox m_cbFlagNotInFileDialog;
    JCheckBox m_cbFlagNotInChooser;
    JCheckBox m_cbFlagAsynchron;
    JCheckBox m_cbFlagReadOnly;
    JCheckBox m_cbFlagNotInstalled;
    JCheckBox m_cbFlagConsultService;
    JCheckBox m_cbFlag3rdPartyFilter;
    JCheckBox m_cbFlagPacked;
    JCheckBox m_cbFlagSilentExport;
    JCheckBox m_cbFlagBrowserPrefered;
    JCheckBox m_cbFlagPrefered;
    JCheckBox m_cbDefaultFirst;
    JCheckBox m_cbUseOrder;
    JCheckBox m_cbCaseSensitive;
    JRadioButton m_rbIFlags;
    JRadioButton m_rbEFlags;
    JRadioButton m_rbAscending;
    JRadioButton m_rbDescending;
    ButtonGroup m_bgFlagUsing;
    ButtonGroup m_bgSorting;

    public FilterQuery() {
        this.impl_init();
        this.m_lChangeListener = new Vector(10, 10);
        this.impl_reset();
    }

    public void addChangeListener(ChangeListener rListener) {
        if (this.m_lChangeListener.contains(rListener)) {
            return;
        }
        this.m_lChangeListener.add(rListener);
        rListener.stateChanged(new ChangeEvent(this));
    }

    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return Locale.getDefault();
        }
    }

    public String getQuery() {
        return this.m_sQuery;
    }

    private void impl_createQuery() {
        String sQuery = new String();
        switch (this.m_bxFactories.getSelectedIndex()) {
            case 0: {
                sQuery = "_query_all";
                break;
            }
            case 1: {
                sQuery = "_query_writer";
                break;
            }
            case 2: {
                sQuery = "_query_web";
                break;
            }
            case 3: {
                sQuery = "_query_global";
                break;
            }
            case 4: {
                sQuery = "_query_calc";
                break;
            }
            case 5: {
                sQuery = "_query_chart";
                break;
            }
            case 6: {
                sQuery = "_query_draw";
                break;
            }
            case 7: {
                sQuery = "_query_impress";
                break;
            }
            case 8: {
                sQuery = "_query_math";
                break;
            }
            case 9: {
                sQuery = "_query_graphics";
                break;
            }
        }
        long nFlags = 0L;
        if (this.m_cbFlagImport.isSelected()) {
            nFlags |= 1L;
        }
        if (this.m_cbFlagExport.isSelected()) {
            nFlags |= 2L;
        }
        if (this.m_cbFlagTemplate.isSelected()) {
            nFlags |= 4L;
        }
        if (this.m_cbFlagIternal.isSelected()) {
            nFlags |= 8L;
        }
        if (this.m_cbFlagTemplatePath.isSelected()) {
            nFlags |= 0x10L;
        }
        if (this.m_cbFlagOwn.isSelected()) {
            nFlags |= 0x20L;
        }
        if (this.m_cbFlagAlien.isSelected()) {
            nFlags |= 0x40L;
        }
        if (this.m_cbFlagUsesOptions.isSelected()) {
            nFlags |= 0x80L;
        }
        if (this.m_cbFlagDefault.isSelected()) {
            nFlags |= 0x100L;
        }
        if (this.m_cbFlagNotInFileDialog.isSelected()) {
            nFlags |= 0x1000L;
        }
        if (this.m_cbFlagNotInChooser.isSelected()) {
            nFlags |= 0x2000L;
        }
        if (this.m_cbFlagAsynchron.isSelected()) {
            nFlags |= 0x4000L;
        }
        if (this.m_cbFlagReadOnly.isSelected()) {
            nFlags |= 0x10000L;
        }
        if (this.m_cbFlagNotInstalled.isSelected()) {
            nFlags |= 0x20000L;
        }
        if (this.m_cbFlagConsultService.isSelected()) {
            nFlags |= 0x40000L;
        }
        if (this.m_cbFlag3rdPartyFilter.isSelected()) {
            nFlags |= 0x80000L;
        }
        if (this.m_cbFlagPacked.isSelected()) {
            nFlags |= 0x100000L;
        }
        if (this.m_cbFlagSilentExport.isSelected()) {
            nFlags |= 0x200000L;
        }
        if (this.m_cbFlagBrowserPrefered.isSelected()) {
            nFlags |= 0x400000L;
        }
        if (this.m_cbFlagPrefered.isSelected()) {
            nFlags |= 0x10000000L;
        }
        sQuery = this.m_rbIFlags.isSelected() ? String.valueOf(sQuery) + ":iflags=" + String.valueOf(nFlags) : String.valueOf(sQuery) + ":eflags=" + String.valueOf(nFlags);
        switch (this.m_bxSortProps.getSelectedIndex()) {
            case 0: {
                sQuery = String.valueOf(sQuery) + ":sort_prop=name";
                break;
            }
            case 1: {
                sQuery = String.valueOf(sQuery) + ":sort_prop=uiname";
                break;
            }
        }
        if (this.m_rbDescending.isSelected()) {
            sQuery = String.valueOf(sQuery) + ":descending";
        }
        if (this.m_cbUseOrder.isSelected()) {
            sQuery = String.valueOf(sQuery) + ":use_order";
        }
        if (this.m_cbDefaultFirst.isSelected()) {
            sQuery = String.valueOf(sQuery) + ":default_first";
        }
        if (this.m_cbCaseSensitive.isSelected()) {
            sQuery = String.valueOf(sQuery) + ":case_sensitive";
        }
        if (sQuery != this.m_sQuery) {
            this.m_sQuery = sQuery;
            ChangeEvent aChangeEvent = new ChangeEvent(this);
            Enumeration lListener = this.m_lChangeListener.elements();
            while (lListener.hasMoreElements()) {
                ((ChangeListener)lListener.nextElement()).stateChanged(aChangeEvent);
            }
        }
    }

    private void impl_init() {
        try {
            this.setLayout(new GridBagLayout());
            Locale aLocale = this.getLocale();
            PropertyResourceBundle aResMgr = (PropertyResourceBundle)ResourceBundle.getBundle(RESSOURCEFILE, aLocale);
            this.m_paFactories = new JPanel();
            this.m_paFactories.setLayout(new GridLayout(0, 1));
            this.m_paFactories.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), aResMgr.getString(RES_TITLE_FACTORIES)));
            this.m_bxFactories = new JComboBox();
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_ALL));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_WRITER));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_WRITER_WEB));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_WRITER_GLOBAL));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_CALC));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_CHART));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_DRAW));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_IMPRESS));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_MATH));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_GRAPHICS));
            this.m_paFactories.add(this.m_bxFactories);
            this.m_bgFlagUsing = new ButtonGroup();
            this.m_rbIFlags = new JRadioButton(aResMgr.getString(RES_FLAGUSING_IFLAGS));
            this.m_rbEFlags = new JRadioButton(aResMgr.getString(RES_FLAGUSING_EFLAGS));
            this.m_bgFlagUsing.add(this.m_rbIFlags);
            this.m_bgFlagUsing.add(this.m_rbEFlags);
            JPanel paFlagUsing = new JPanel();
            paFlagUsing.setLayout(new GridLayout(0, 1));
            paFlagUsing.add(this.m_rbIFlags);
            paFlagUsing.add(this.m_rbEFlags);
            String[] lFlags = ALL_FLAGRES_NAMES;
            RessourceHelper.resolveResNames("filterui.res.Filter", aLocale, lFlags);
            this.m_cbFlagImport = new JCheckBox(lFlags[0]);
            this.m_cbFlagExport = new JCheckBox(lFlags[1]);
            this.m_cbFlagTemplate = new JCheckBox(lFlags[2]);
            this.m_cbFlagIternal = new JCheckBox(lFlags[3]);
            this.m_cbFlagTemplatePath = new JCheckBox(lFlags[4]);
            this.m_cbFlagOwn = new JCheckBox(lFlags[5]);
            this.m_cbFlagAlien = new JCheckBox(lFlags[6]);
            this.m_cbFlagUsesOptions = new JCheckBox(lFlags[7]);
            this.m_cbFlagDefault = new JCheckBox(lFlags[8]);
            this.m_cbFlagNotInFileDialog = new JCheckBox(lFlags[9]);
            this.m_cbFlagNotInChooser = new JCheckBox(lFlags[10]);
            this.m_cbFlagAsynchron = new JCheckBox(lFlags[11]);
            this.m_cbFlagReadOnly = new JCheckBox(lFlags[12]);
            this.m_cbFlagNotInstalled = new JCheckBox(lFlags[13]);
            this.m_cbFlagConsultService = new JCheckBox(lFlags[14]);
            this.m_cbFlag3rdPartyFilter = new JCheckBox(lFlags[15]);
            this.m_cbFlagPacked = new JCheckBox(lFlags[16]);
            this.m_cbFlagSilentExport = new JCheckBox(lFlags[17]);
            this.m_cbFlagBrowserPrefered = new JCheckBox(lFlags[18]);
            this.m_cbFlagPrefered = new JCheckBox(lFlags[19]);
            JPanel paFlagChecks = new JPanel();
            paFlagChecks.setLayout(new GridLayout(5, 4));
            paFlagChecks.add(this.m_cbFlagImport);
            paFlagChecks.add(this.m_cbFlagExport);
            paFlagChecks.add(this.m_cbFlagTemplate);
            paFlagChecks.add(this.m_cbFlagIternal);
            paFlagChecks.add(this.m_cbFlagTemplatePath);
            paFlagChecks.add(this.m_cbFlagOwn);
            paFlagChecks.add(this.m_cbFlagAlien);
            paFlagChecks.add(this.m_cbFlagUsesOptions);
            paFlagChecks.add(this.m_cbFlagDefault);
            paFlagChecks.add(this.m_cbFlagNotInFileDialog);
            paFlagChecks.add(this.m_cbFlagNotInChooser);
            paFlagChecks.add(this.m_cbFlagAsynchron);
            paFlagChecks.add(this.m_cbFlagReadOnly);
            paFlagChecks.add(this.m_cbFlagNotInstalled);
            paFlagChecks.add(this.m_cbFlagConsultService);
            paFlagChecks.add(this.m_cbFlag3rdPartyFilter);
            paFlagChecks.add(this.m_cbFlagPacked);
            paFlagChecks.add(this.m_cbFlagSilentExport);
            paFlagChecks.add(this.m_cbFlagBrowserPrefered);
            paFlagChecks.add(this.m_cbFlagPrefered);
            this.m_paFlags = new JPanel();
            this.m_paFlags.setLayout(new FlowLayout(4));
            this.m_paFlags.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), aResMgr.getString(RES_TITLE_FLAGS)));
            this.m_paFlags.add(paFlagUsing);
            this.m_paFlags.add(paFlagChecks);
            this.m_bgSorting = new ButtonGroup();
            this.m_rbAscending = new JRadioButton(aResMgr.getString(RES_SORT_ASCENDING));
            this.m_rbDescending = new JRadioButton(aResMgr.getString(RES_SORT_DESCENDING));
            this.m_bgSorting.add(this.m_rbAscending);
            this.m_bgSorting.add(this.m_rbDescending);
            this.m_cbDefaultFirst = new JCheckBox(aResMgr.getString(RES_SORT_DEFAULT_FIRST));
            this.m_cbUseOrder = new JCheckBox(aResMgr.getString(RES_SORT_USE_ORDER));
            this.m_cbCaseSensitive = new JCheckBox(aResMgr.getString(RES_SORT_CASE_SENSITIVE));
            this.m_bxSortProps = new JComboBox();
            this.m_bxSortProps.addItem(aResMgr.getString(RES_SORTPROP_NAME));
            this.m_bxSortProps.addItem(aResMgr.getString(RES_SORTPROP_UINAME));
            this.m_paSorting = new JPanel();
            this.m_paSorting.setLayout(new GridLayout(0, 1));
            this.m_paSorting.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), aResMgr.getString(RES_TITLE_SORTING)));
            this.m_paSorting.add(this.m_rbAscending);
            this.m_paSorting.add(this.m_rbDescending);
            this.m_paSorting.add(this.m_bxSortProps);
            this.m_paSorting.add(this.m_cbDefaultFirst);
            this.m_paSorting.add(this.m_cbUseOrder);
            this.m_paSorting.add(this.m_cbCaseSensitive);
            this.m_paActions = new JPanel();
            this.m_paActions.setLayout(new GridLayout(0, 1));
            this.m_paActions.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), aResMgr.getString(RES_TITLE_ACTIONS)));
            String sTextOK = aResMgr.getString(RES_ACTION_QUERY);
            String sTextReset = aResMgr.getString(RES_ACTION_RESET);
            this.m_btQuery = new JButton(sTextOK);
            this.m_btReset = new JButton(sTextReset);
            this.m_btQuery.setMnemonic(sTextOK.charAt(0));
            this.m_btReset.setMnemonic(sTextReset.charAt(0));
            this.m_btQuery.setActionCommand(ACTIONCOMMAND_QUERY);
            this.m_btReset.setActionCommand(ACTIONCOMMAND_RESET);
            this.m_paActions.add(this.m_btQuery);
            this.m_paActions.add(this.m_btReset);
            GridBagConstraints aConstraint = new GridBagConstraints();
            aConstraint.anchor = 18;
            aConstraint.insets = new Insets(2, 2, 2, 2);
            aConstraint.gridy = 0;
            aConstraint.gridx = 0;
            this.add((Component)this.m_paFactories, aConstraint);
            ++aConstraint.gridx;
            this.add((Component)this.m_paFlags, aConstraint);
            ++aConstraint.gridx;
            this.add((Component)this.m_paSorting, aConstraint);
            ++aConstraint.gridx;
            this.add((Component)this.m_paActions, aConstraint);
        }
        catch (MissingResourceException exMissingRes) {
            System.out.println("FilterQuery::impl_init()\n\t" + exMissingRes.getMessage());
        }
        this.m_btQuery.addActionListener(new ImplActionListener());
        this.m_btReset.addActionListener(new ImplActionListener());
    }

    private void impl_reset() {
        this.m_bxFactories.setSelectedIndex(0);
        this.m_bxSortProps.setSelectedIndex(0);
        this.m_rbIFlags.setSelected(true);
        this.m_rbAscending.setSelected(true);
        this.m_cbFlagImport.setSelected(false);
        this.m_cbFlagExport.setSelected(false);
        this.m_cbFlagTemplate.setSelected(false);
        this.m_cbFlagIternal.setSelected(false);
        this.m_cbFlagTemplatePath.setSelected(false);
        this.m_cbFlagOwn.setSelected(false);
        this.m_cbFlagAlien.setSelected(false);
        this.m_cbFlagUsesOptions.setSelected(false);
        this.m_cbFlagDefault.setSelected(false);
        this.m_cbFlagNotInFileDialog.setSelected(false);
        this.m_cbFlagNotInChooser.setSelected(false);
        this.m_cbFlagAsynchron.setSelected(false);
        this.m_cbFlagReadOnly.setSelected(false);
        this.m_cbFlagNotInstalled.setSelected(false);
        this.m_cbFlagConsultService.setSelected(false);
        this.m_cbFlag3rdPartyFilter.setSelected(false);
        this.m_cbFlagPacked.setSelected(false);
        this.m_cbFlagSilentExport.setSelected(false);
        this.m_cbFlagBrowserPrefered.setSelected(false);
        this.m_cbFlagPrefered.setSelected(false);
        this.m_cbDefaultFirst.setSelected(false);
        this.m_cbUseOrder.setSelected(false);
        this.m_cbCaseSensitive.setSelected(true);
        this.impl_createQuery();
    }

    public void removeChangeListener(ChangeListener rListener) {
        if (this.m_lChangeListener.contains(rListener)) {
            this.m_lChangeListener.remove(rListener);
        }
    }

    public void setLocale(Locale aLocale) {
        try {
            if (super.getLocale().toString().compareTo(aLocale.toString()) == 0) {
                return;
            }
            PropertyResourceBundle aResMgr = (PropertyResourceBundle)ResourceBundle.getBundle(RESSOURCEFILE, aLocale);
            TitledBorder rBorder = (TitledBorder)this.m_paFactories.getBorder();
            rBorder.setTitle(aResMgr.getString(RES_TITLE_FACTORIES));
            rBorder = (TitledBorder)this.m_paFlags.getBorder();
            rBorder.setTitle(aResMgr.getString(RES_TITLE_FLAGS));
            rBorder = (TitledBorder)this.m_paSorting.getBorder();
            rBorder.setTitle(aResMgr.getString(RES_TITLE_SORTING));
            rBorder = (TitledBorder)this.m_paActions.getBorder();
            rBorder.setTitle(aResMgr.getString(RES_TITLE_ACTIONS));
            int nSelectedItem = this.m_bxFactories.getSelectedIndex();
            this.m_bxFactories.removeAllItems();
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_ALL));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_WRITER));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_WRITER_WEB));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_WRITER_GLOBAL));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_CALC));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_CHART));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_DRAW));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_IMPRESS));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_MATH));
            this.m_bxFactories.addItem(aResMgr.getString(RES_FACTORY_GRAPHICS));
            this.m_bxFactories.setSelectedIndex(nSelectedItem);
            this.m_rbIFlags.setText(aResMgr.getString(RES_FLAGUSING_IFLAGS));
            this.m_rbEFlags.setText(aResMgr.getString(RES_FLAGUSING_EFLAGS));
            String[] lFlags = ALL_FLAGRES_NAMES;
            RessourceHelper.resolveResNames("filterui.res.Filter", aLocale, lFlags);
            this.m_cbFlagImport.setText(lFlags[0]);
            this.m_cbFlagExport.setText(lFlags[1]);
            this.m_cbFlagTemplate.setText(lFlags[2]);
            this.m_cbFlagIternal.setText(lFlags[3]);
            this.m_cbFlagTemplatePath.setText(lFlags[4]);
            this.m_cbFlagOwn.setText(lFlags[5]);
            this.m_cbFlagAlien.setText(lFlags[6]);
            this.m_cbFlagUsesOptions.setText(lFlags[7]);
            this.m_cbFlagDefault.setText(lFlags[8]);
            this.m_cbFlagNotInFileDialog.setText(lFlags[9]);
            this.m_cbFlagNotInChooser.setText(lFlags[10]);
            this.m_cbFlagAsynchron.setText(lFlags[11]);
            this.m_cbFlagReadOnly.setText(lFlags[12]);
            this.m_cbFlagNotInstalled.setText(lFlags[13]);
            this.m_cbFlagConsultService.setText(lFlags[14]);
            this.m_cbFlag3rdPartyFilter.setText(lFlags[15]);
            this.m_cbFlagPacked.setText(lFlags[16]);
            this.m_cbFlagSilentExport.setText(lFlags[17]);
            this.m_cbFlagBrowserPrefered.setText(lFlags[18]);
            this.m_cbFlagPrefered.setText(lFlags[19]);
            this.m_rbAscending.setText(aResMgr.getString(RES_SORT_ASCENDING));
            this.m_rbDescending.setText(aResMgr.getString(RES_SORT_DESCENDING));
            this.m_cbDefaultFirst.setText(aResMgr.getString(RES_SORT_DEFAULT_FIRST));
            this.m_cbUseOrder.setText(aResMgr.getString(RES_SORT_USE_ORDER));
            this.m_cbCaseSensitive.setText(aResMgr.getString(RES_SORT_CASE_SENSITIVE));
            nSelectedItem = this.m_bxSortProps.getSelectedIndex();
            this.m_bxSortProps.removeAllItems();
            this.m_bxSortProps.addItem(aResMgr.getString(RES_SORTPROP_NAME));
            this.m_bxSortProps.addItem(aResMgr.getString(RES_SORTPROP_UINAME));
            this.m_bxSortProps.setSelectedIndex(nSelectedItem);
            this.m_btQuery.setText(aResMgr.getString(RES_ACTION_QUERY));
            this.m_btReset.setText(aResMgr.getString(RES_ACTION_RESET));
            super.setLocale(aLocale);
        }
        catch (MissingResourceException exMissingRes) {
            System.out.println("FilterQuery::setLocale()\n\t" + exMissingRes.getMessage());
        }
    }

    class ImplActionListener
    implements ActionListener {
        ImplActionListener() {
        }

        public void actionPerformed(ActionEvent aEvent) {
            String sCommand = aEvent.getActionCommand();
            if (sCommand == FilterQuery.ACTIONCOMMAND_QUERY) {
                FilterQuery.this.impl_createQuery();
            } else if (sCommand == FilterQuery.ACTIONCOMMAND_RESET) {
                FilterQuery.this.impl_reset();
            }
        }
    }
}

