/*
 * Decompiled with CFR 0.152.
 */
package filterui;

import filterui.CFGCache;
import filterui.FileType;
import filterui.Filter;
import filterui.FilterPropView;
import filterui.FilterQuery;
import filterui.TypePropView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MainFrame
extends JFrame {
    public static final String RESSOURCEFILE = "filterui.res.MainFrame";
    private static final String COMMAND_SETLOCALE_DE_DE = "setLocale_de_DE";
    private static final String COMMAND_SETLOCALE_EN_US = "setLocale_en_US";
    private static final String RES_MENU_LOCALE = "MainFrame.locale";
    private static final String RES_MENU_LOCALE_GERMAN = "MainFrame.locale_de_de";
    private static final String RES_MENU_LOCALE_ENGLISH = "MainFrame.locale_en_us";
    private static final String RES_TITLE_MAIN = "MainFrame.title_main";
    private static final String RES_TITLE_FILTERPROPS = "MainFrame.title_filterprops";
    private static final String RES_TITLE_TYPEPROPS = "MainFrame.title_typeprops";
    JPanel m_aMainPanel;
    JMenuBar m_mbMain;
    JMenu m_muLocale;
    JMenuItem m_miLocaleDeDe;
    JMenuItem m_miLocaleEnUs;
    JList m_aFilterList;
    CFGCache m_aFilterCache;
    FilterQuery m_aFilterQuery;
    FilterPropView m_aFilterPropView;
    TypePropView m_aTypePropView;

    public MainFrame() {
        this.enableEvents(64L);
        this.impl_init();
    }

    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return Locale.getDefault();
        }
    }

    private void impl_init() {
        Locale aLocale = this.getLocale();
        PropertyResourceBundle aResMgr = (PropertyResourceBundle)ResourceBundle.getBundle(RESSOURCEFILE, aLocale);
        ((Component)this).setSize(new Dimension(1225, 955));
        this.setTitle(aResMgr.getString(RES_TITLE_MAIN));
        this.m_aMainPanel = (JPanel)this.getContentPane();
        this.m_aMainPanel.setLayout(new BorderLayout());
        this.m_mbMain = new JMenuBar();
        this.m_muLocale = new JMenu();
        this.m_miLocaleDeDe = new JMenuItem();
        this.m_miLocaleEnUs = new JMenuItem();
        this.m_muLocale.setText(aResMgr.getString(RES_MENU_LOCALE));
        this.m_miLocaleDeDe.setText(aResMgr.getString(RES_MENU_LOCALE_GERMAN));
        this.m_miLocaleEnUs.setText(aResMgr.getString(RES_MENU_LOCALE_ENGLISH));
        this.m_miLocaleDeDe.setActionCommand(COMMAND_SETLOCALE_DE_DE);
        this.m_miLocaleEnUs.setActionCommand(COMMAND_SETLOCALE_EN_US);
        this.m_muLocale.add(this.m_miLocaleDeDe);
        this.m_muLocale.add(this.m_miLocaleEnUs);
        this.m_mbMain.add(this.m_muLocale);
        ImplMenuListener aMenuReaction = new ImplMenuListener();
        this.m_miLocaleDeDe.addActionListener(aMenuReaction);
        this.m_miLocaleEnUs.addActionListener(aMenuReaction);
        this.setJMenuBar(this.m_mbMain);
        this.m_aFilterPropView = new FilterPropView(true);
        this.m_aTypePropView = new TypePropView(true);
        this.m_aFilterList = new JList();
        this.m_aFilterCache = new CFGCache();
        this.m_aFilterQuery = new FilterQuery();
        this.m_aFilterList.setSelectionMode(0);
        this.m_aFilterPropView.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), aResMgr.getString(RES_TITLE_FILTERPROPS)));
        this.m_aTypePropView.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), aResMgr.getString(RES_TITLE_TYPEPROPS)));
        JScrollPane paScrollableListView = new JScrollPane();
        paScrollableListView.getViewport().add((Component)this.m_aFilterList, null);
        JPanel paPropView = new JPanel(new GridLayout(0, 1));
        JScrollPane paScrollablePropView = new JScrollPane();
        JViewport aView = paScrollablePropView.getViewport();
        paPropView.add(this.m_aFilterPropView);
        paPropView.add(this.m_aTypePropView);
        aView.add(paPropView);
        JSplitPane spSplitter = new JSplitPane();
        spSplitter.setOneTouchExpandable(true);
        spSplitter.add((Component)paScrollableListView, "left");
        spSplitter.add((Component)paScrollablePropView, "right");
        JScrollPane paScrollableQueryView = new JScrollPane();
        paScrollableQueryView.getViewport().add((Component)this.m_aFilterQuery, null);
        this.m_aMainPanel.add((Component)paScrollableQueryView, "North");
        this.m_aMainPanel.add((Component)spSplitter, "Center");
        this.m_aFilterQuery.addChangeListener(new ImplQueryListener());
        this.m_aFilterList.addListSelectionListener(new ImplFilterSelectionListener());
        this.m_aFilterList.clearSelection();
        this.m_aFilterList.setSelectedIndex(0);
        this.m_aFilterQuery.setLocale(aLocale);
        this.m_aFilterList.setLocale(aLocale);
        this.m_aFilterPropView.setLocale(aLocale);
        this.m_aTypePropView.setLocale(aLocale);
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    public void setLocale(Locale aLocale) {
        if (super.getLocale().toString().compareTo(aLocale.toString()) == 0) {
            return;
        }
        PropertyResourceBundle aResMgr = (PropertyResourceBundle)ResourceBundle.getBundle(RESSOURCEFILE, aLocale);
        this.setTitle(aResMgr.getString(RES_TITLE_MAIN));
        this.m_muLocale.setText(aResMgr.getString(RES_MENU_LOCALE));
        this.m_miLocaleDeDe.setText(aResMgr.getString(RES_MENU_LOCALE_GERMAN));
        this.m_miLocaleEnUs.setText(aResMgr.getString(RES_MENU_LOCALE_ENGLISH));
        TitledBorder rBorder = (TitledBorder)this.m_aFilterPropView.getBorder();
        rBorder.setTitle(aResMgr.getString(RES_TITLE_FILTERPROPS));
        rBorder = (TitledBorder)this.m_aTypePropView.getBorder();
        rBorder.setTitle(aResMgr.getString(RES_TITLE_TYPEPROPS));
        this.m_aFilterQuery.setLocale(aLocale);
        this.m_aFilterList.setLocale(aLocale);
        this.m_aFilterPropView.setLocale(aLocale);
        this.m_aTypePropView.setLocale(aLocale);
        super.setLocale(aLocale);
    }

    class ImplMenuListener
    implements ActionListener {
        ImplMenuListener() {
        }

        public void actionPerformed(ActionEvent aEvent) {
            String sCommand = aEvent.getActionCommand();
            if (sCommand.compareTo(MainFrame.COMMAND_SETLOCALE_DE_DE) == 0) {
                System.out.println("Ressources not localized yet! Can you do it?");
                MainFrame.this.setLocale(new Locale("de", null));
            } else if (sCommand.compareTo(MainFrame.COMMAND_SETLOCALE_EN_US) == 0) {
                MainFrame.this.setLocale(new Locale("en", "US"));
            }
        }
    }

    class ImplQueryListener
    implements ChangeListener {
        ImplQueryListener() {
        }

        public void stateChanged(ChangeEvent aEvent) {
            String sQuery = MainFrame.this.m_aFilterQuery.getQuery();
            String[] lFilters = MainFrame.this.m_aFilterCache.queryFilters(sQuery);
            MainFrame.this.m_aFilterList.setListData(lFilters);
            MainFrame.this.m_aFilterList.setSelectedIndex(0);
        }
    }

    class ImplFilterSelectionListener
    implements ListSelectionListener {
        ImplFilterSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent aEvent) {
            if (aEvent.getValueIsAdjusting()) {
                return;
            }
            if (!MainFrame.this.m_aFilterList.isSelectionEmpty()) {
                Filter aFilter = MainFrame.this.m_aFilterCache.getFilter((String)MainFrame.this.m_aFilterList.getSelectedValue());
                FileType aType = MainFrame.this.m_aFilterCache.getType(aFilter.m_sType);
                MainFrame.this.m_aFilterPropView.setFilter(aFilter);
                MainFrame.this.m_aTypePropView.setType(aType);
            }
        }
    }
}

