/*
 * Decompiled with CFR 0.152.
 */
package filterui;

import filterui.TPropertyEditInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PropertyEditBase
extends JPanel {
    private String m_sRessource;
    private Hashtable m_lPropertySet = new Hashtable();

    private PropertyEditBase() {
    }

    private PropertyEditBase(LayoutManager aLayout) {
    }

    private PropertyEditBase(LayoutManager aLayout, boolean bIsDoubleBuffered) {
    }

    public PropertyEditBase(String sRessource) {
        this.m_sRessource = sRessource;
        this.setLayout(new GridBagLayout());
    }

    private PropertyEditBase(boolean bIsDoubleBuffered) {
    }

    protected void createEditPairs(TPropertyEditInfo[] lInfos) {
        this.m_lPropertySet.clear();
        this.removeAll();
        PropertyResourceBundle aResMgr = (PropertyResourceBundle)ResourceBundle.getBundle(this.m_sRessource, this.getLocale());
        GridBagConstraints aConstraint = new GridBagConstraints();
        aConstraint.anchor = 18;
        aConstraint.insets = new Insets(2, 2, 2, 2);
        int nPairs = lInfos.length;
        int i = 0;
        while (i < nPairs) {
            TPropertyEditInfo rInfo = lInfos[i];
            ImplPropertyPair aPair = new ImplPropertyPair();
            aPair.sLabelRes = rInfo.sProperty;
            aPair.sToolTipRes = rInfo.sToolTip;
            aPair.rLabel = new JLabel(aResMgr.getString(aPair.sLabelRes));
            aConstraint.gridy = i;
            aConstraint.gridx = 0;
            this.add((Component)aPair.rLabel, aConstraint);
            aConstraint.gridx = 1;
            switch (rInfo.ePairType) {
                case 1: {
                    JTextField aTextField = new JTextField(rInfo.nRangeX);
                    aTextField.setToolTipText(aResMgr.getString(aPair.sToolTipRes));
                    aTextField.setEditable(rInfo.bReadOnly ^ true);
                    aPair.rLabel.setLabelFor(aTextField);
                    aPair.rComponent = aTextField;
                    this.add((Component)aPair.rComponent, aConstraint);
                    break;
                }
                case 2: {
                    JComboBox aComboBox = new JComboBox();
                    aComboBox.setToolTipText(aResMgr.getString(aPair.sToolTipRes));
                    aComboBox.setEditable(rInfo.bReadOnly ^ true);
                    aPair.rLabel.setLabelFor(aComboBox);
                    aPair.rComponent = aComboBox;
                    this.add((Component)aPair.rComponent, aConstraint);
                    break;
                }
                case 3: 
                case 4: {
                    JList aList = new JList();
                    JScrollPane aScroll = new JScrollPane(aList);
                    aList.setToolTipText(aResMgr.getString(aPair.sToolTipRes));
                    aList.setEnabled(rInfo.bReadOnly ^ true);
                    aList.setVisibleRowCount(rInfo.nRangeY);
                    aList.setFixedCellWidth(rInfo.nRangeX);
                    aPair.rLabel.setLabelFor(aList);
                    aPair.rComponent = aScroll;
                    this.add((Component)aPair.rComponent, aConstraint);
                    break;
                }
            }
            this.m_lPropertySet.put(rInfo.sProperty, aPair);
            ++i;
        }
    }

    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return Locale.getDefault();
        }
    }

    public void setLocale(Locale aLocale) {
        this.setEnabled(false);
        PropertyResourceBundle aResMgr = (PropertyResourceBundle)ResourceBundle.getBundle(this.m_sRessource, aLocale);
        Enumeration aSnapshot = this.m_lPropertySet.elements();
        while (aSnapshot.hasMoreElements()) {
            ImplPropertyPair rPair = (ImplPropertyPair)aSnapshot.nextElement();
            rPair.rLabel.setText(aResMgr.getString(rPair.sLabelRes));
        }
        this.setEnabled(true);
        super.setLocale(aLocale);
    }

    protected void setPropValue(String sPropName, String sValue, String[] lValue) {
        this.setEnabled(false);
        Enumeration aSnapshot = this.m_lPropertySet.keys();
        while (aSnapshot.hasMoreElements()) {
            String rPropName = (String)aSnapshot.nextElement();
            if (rPropName != sPropName) continue;
            ImplPropertyPair rPair = (ImplPropertyPair)this.m_lPropertySet.get(rPropName);
            if (rPair.rComponent.getClass().getName().compareTo("javax.swing.JTextField") == 0) {
                JTextField aEdit = (JTextField)rPair.rComponent;
                aEdit.setText(sValue);
                break;
            }
            if (rPair.rComponent.getClass().getName().compareTo("javax.swing.JComboBox") == 0) {
                JComboBox aBox = (JComboBox)rPair.rComponent;
                aBox.removeAllItems();
                int i = 0;
                while (i < lValue.length) {
                    aBox.addItem(lValue[i]);
                    ++i;
                }
                break;
            }
            if (rPair.rComponent.getClass().getName().compareTo("javax.swing.JScrollPane") != 0) continue;
            JList aList = (JList)((JScrollPane)rPair.rComponent).getViewport().getView();
            aList.setListData(lValue);
            break;
        }
        this.setEnabled(true);
    }

    private class ImplPropertyPair {
        public JLabel rLabel;
        public JComponent rComponent;
        public String sLabelRes;
        public String sToolTipRes;

        ImplPropertyPair() {
        }
    }
}

