import javax.swing.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.BorderLayout; 
import java.awt.GridLayout;
import java.awt.FlowLayout; 
import javax.swing.JButton; 
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Color;

import drafts.com.sun.star.script.framework.XScriptContext;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;
import com.sun.star.text.*;

/**
 *  HighlightText class
 *  interface for the HighlightText class
 *
 * @author      Neil Montgomery
 * @created     September 23, 2002
 */
public class HighlightText {
  // Swing components for the user interface
  private static String searchKey = "";
  private static JTextField findTextBox = null;

  // Global HighlightUtil reference
  private static HighlightUtil highlight = null;
  

        /*
         * Displays the user interface
         *
         * @param   XScriptContext    receives an XScriptContext from the scripting framework
         */
  public static void showForm(XScriptContext xSc) {

    // getting the text document object
    XComponent xcomponent = xSc.getDocument();
    XTextDocument xtextdocument = (XTextDocument) UnoRuntime.queryInterface(
XTextDocument.class, xcomponent);

    // Passes the XTextDocument to HighlightUtil constructor
    highlight = new HighlightUtil(xtextdocument);



    // Create a JButton and add an ActionListener
    // When clicked the value for the searchKey is read and passed to the replaceText method of the HighlightUtil class

    JButton searchButton = new JButton("Highlight");
    searchButton.addActionListener(new ActionListener() {
       public void actionPerformed(ActionEvent e) {

          searchKey = findTextBox.getText();

          if(searchKey.equalsIgnoreCase("")) {
             JOptionPane.showMessageDialog(null, "No text entered for search", "No text", JOptionPane.INFORMATION_MESSAGE);
          }
          else {
             // highlight the text in red
             Color cRed = new Color(255, 0, 0);
             int red = cRed.getRGB();
             int numberOccurances = highlight.replaceText(searchKey, red, true);

             if(numberOccurances > 0) {
                int response = JOptionPane.showConfirmDialog(null, searchKey + " was found " + numberOccurances + " times\nDo you wish to keep the text highlighted?", "Confirm highlight", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
                if(response == 1) {
                   Color cBlack = new Color(255, 255, 255);
                   int black = cBlack.getRGB();
	           highlight.replaceText(searchKey, black, false);
                }
             }
             else {
                JOptionPane.showMessageDialog(null, "No matches were found", "Not found", JOptionPane.INFORMATION_MESSAGE);
             }
          }
       }
    });


    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new FlowLayout());
    buttonPanel.add(searchButton);


    // Create a JPanel containing one JTextField for the search text. 
    JPanel searchPanel = new JPanel();
    searchPanel.setLayout(new FlowLayout());
    findTextBox = new JTextField(20);
    JLabel findWhat = new JLabel("Find What: ");
    searchPanel.add(findWhat);
    searchPanel.add(findTextBox);


    // Create frame and add a window listener
    JFrame frame = new JFrame("Highlight Text");
    frame.setSize(350,130);
    frame.setLocation(430,430);
    frame.setResizable(false);

    // Add the panel and button to the frame
    frame.getContentPane().setLayout(new GridLayout(2,1,10,10));
    frame.getContentPane().add(searchPanel);
    frame.getContentPane().add(buttonPanel);

    frame.setVisible(true);

  }// showForm

}
