import com.sun.star.frame.XDesktop;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.XComponent;

import com.sun.star.util.XPropertyReplace;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.PropertyValue;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XText;
import com.sun.star.awt.XTextComponent;

import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
 
import java.awt.Color;

/**
 *  HighlightUtil Class
 *  Finds all instances of a string in the document, highlights them and returns the number of occurences 
 *
 * @author      Neil Montgomery
 * @created     September 23, 2002
 */
public class HighlightUtil {

  // Global reference to the XTextDocument 
  XTextDocument xTextDocument = null;


        /**
	 * Constructor for HighlightUtil class
         *
         * Receives a XTextDocument 
         * 
         */
  public HighlightUtil(XTextDocument xtd) {
    xTextDocument = xtd; 
  }// constructor


	/**
	 * Searches for all instances of a specified string, alters their property values to highlight all occurences of the string and returns the number of occurences of the string 
	 *
	 * @param 	searchKey	string to be searched for in the document
	 * @param	color	        RGB integer value for new font color
         * @param       bold            boolean for bold or normal font weight
	 * @exception Exception if the text couldn't be replaced
	 */
  public int replaceText(String searchKey, int color, boolean bold) {
    int numberReplaced = 0;
    try {
       // Creates an XReplaceable object and an XReplaceDescriptor from the XTextDocument
       XReplaceable xReplaceable = (XReplaceable) UnoRuntime.queryInterface(XReplaceable.class, xTextDocument); 

       XReplaceDescriptor xReplaceDescriptor = (XReplaceDescriptor) xReplaceable.createReplaceDescriptor();

       // Gets a XPropertyReplace object for altering the properties of the replaced text
       XPropertyReplace xpropertyreplace = (XPropertyReplace) UnoRuntime.queryInterface(XPropertyReplace.class, xReplaceDescriptor);

       // Sets the replaced text property fontweight value to Bold or Normal 
       PropertyValue weightValue = null;
       if(bold) {
          weightValue = new PropertyValue("CharWeight", -1, new Float(com.sun.star.awt.FontWeight.BOLD), com.sun.star.beans.PropertyState.DIRECT_VALUE);
       }
       else {
          weightValue = new PropertyValue("CharWeight", -1, new Float(com.sun.star.awt.FontWeight.NORMAL), com.sun.star.beans.PropertyState.DIRECT_VALUE);
       }

       // Sets the replaced text property color value to RGB color parameter
       PropertyValue colorValue = new PropertyValue("CharColor", -1, new Integer(color), com.sun.star.beans.PropertyState.DIRECT_VALUE);

       // Apply the properties
       PropertyValue[] propertyvalues = { colorValue, weightValue }; 
       xpropertyreplace.setReplaceAttributes(propertyvalues);

       // Only matches whole words and case sensitive
       xReplaceDescriptor.setPropertyValue("SearchCaseSensitive", new Boolean(true));
       xReplaceDescriptor.setPropertyValue("SearchWords", new Boolean(true));

       // Replaces all instances of searchKey with new Text properties and gets the number of instances of the searchKey 
       xReplaceDescriptor.setSearchString(searchKey); 
       xReplaceDescriptor.setReplaceString(searchKey); 
       numberReplaced = xReplaceable.replaceAll(xReplaceDescriptor);

    } catch (Exception e) {
      System.out.println("Couldn't replace text: "+ e);
    }
    return numberReplaced;
  }// replaceText

}// HighlightUtil
