/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Invoker;

public class InvokerImpl
extends Invoker {
    int classNumber;
    Hashtable invokersCache;
    GeneratedClassLoader classLoader;

    public Invoker createInvoker(Context cx, Method method, Class[] types) {
        int classNum;
        Invoker result;
        InvokerImpl invokerImpl = this;
        synchronized (invokerImpl) {
            if (this.invokersCache == null) {
                this.invokersCache = new Hashtable();
                ClassLoader parentLoader = cx.getClass().getClassLoader();
                this.classLoader = cx.createClassLoader(parentLoader);
            } else {
                result = (Invoker)this.invokersCache.get(method);
                if (result != null) {
                    Invoker parentLoader = result;
                    return parentLoader;
                }
            }
            classNum = ++this.classNumber;
        }
        String className = "inv" + classNum;
        ClassFileWriter cfw = new ClassFileWriter(className, "org.mozilla.javascript.Invoker", "");
        cfw.setFlags((short)17);
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add((byte)42);
        cfw.add((byte)-73, "org.mozilla.javascript.Invoker", "<init>", "()", "V");
        cfw.add((byte)-79);
        cfw.stopMethod((short)1, null);
        cfw.startMethod("invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        String declaringClassName = method.getDeclaringClass().getName().replace('.', '/');
        Class<?> returnType = method.getReturnType();
        String invokeSpecial = null;
        String invokeSpecialType = null;
        boolean returnsVoid = false;
        boolean returnsBoolean = false;
        if (returnType.isPrimitive()) {
            if (returnType == Boolean.TYPE) {
                returnsBoolean = true;
                invokeSpecialType = "(Z)";
            } else if (returnType == Void.TYPE) {
                returnsVoid = true;
                invokeSpecialType = "(V)";
            } else if (returnType == Integer.TYPE) {
                invokeSpecial = "java/lang/Integer";
                cfw.add((byte)-69, "java/lang/Integer");
                cfw.add((byte)89);
                invokeSpecialType = "(I)";
            } else if (returnType == Long.TYPE) {
                invokeSpecial = "java/lang/Long";
                cfw.add((byte)-69, "java/lang/Long");
                cfw.add((byte)89);
                invokeSpecialType = "(J)";
            } else if (returnType == Short.TYPE) {
                invokeSpecial = "java/lang/Short";
                cfw.add((byte)-69, "java/lang/Short");
                cfw.add((byte)89);
                invokeSpecialType = "(S)";
            } else if (returnType == Float.TYPE) {
                invokeSpecial = "java/lang/Float";
                cfw.add((byte)-69, "java/lang/Float");
                cfw.add((byte)89);
                invokeSpecialType = "(F)";
            } else if (returnType == Double.TYPE) {
                invokeSpecial = "java/lang/Double";
                cfw.add((byte)-69, "java/lang/Double");
                cfw.add((byte)89);
                invokeSpecialType = "(D)";
            } else if (returnType == Byte.TYPE) {
                invokeSpecial = "java/lang/Byte";
                cfw.add((byte)-69, "java/lang/Byte");
                cfw.add((byte)89);
                invokeSpecialType = "(B)";
            } else if (returnType == Character.TYPE) {
                invokeSpecial = "java/lang/Character";
                cfw.add((byte)-69, "java/lang/Character");
                cfw.add((byte)89);
                invokeSpecialType = "(C)";
            }
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            cfw.add((byte)43);
            cfw.add((byte)-64, declaringClassName);
        }
        StringBuffer params = new StringBuffer(2 + (types != null ? 20 * types.length : 0));
        params.append('(');
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                Class type = types[i];
                cfw.add((byte)44);
                if (i <= 5) {
                    cfw.add((byte)(3 + i));
                } else if (i <= 127) {
                    cfw.add((byte)16, i);
                } else if (i <= Short.MAX_VALUE) {
                    cfw.add((byte)17, i);
                } else {
                    cfw.addLoadConstant(i);
                }
                cfw.add((byte)50);
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        cfw.add((byte)-64, "java/lang/Boolean");
                        cfw.add((byte)-74, "java/lang/Boolean", "booleanValue", "()", "Z");
                        params.append('Z');
                    } else if (type == Integer.TYPE) {
                        cfw.add((byte)-64, "java/lang/Number");
                        cfw.add((byte)-74, "java/lang/Number", "intValue", "()", "I");
                        params.append('I');
                    } else if (type == Short.TYPE) {
                        cfw.add((byte)-64, "java/lang/Number");
                        cfw.add((byte)-74, "java/lang/Number", "shortValue", "()", "S");
                        params.append('S');
                    } else if (type == Character.TYPE) {
                        cfw.add((byte)-64, "java/lang/Character");
                        cfw.add((byte)-74, "java/lang/Character", "charValue", "()", "C");
                        params.append('C');
                    } else if (type == Double.TYPE) {
                        cfw.add((byte)-64, "java/lang/Number");
                        cfw.add((byte)-74, "java/lang/Number", "doubleValue", "()", "D");
                        params.append('D');
                    } else if (type == Float.TYPE) {
                        cfw.add((byte)-64, "java/lang/Number");
                        cfw.add((byte)-74, "java/lang/Number", "floatValue", "()", "F");
                        params.append('F');
                    } else if (type == Byte.TYPE) {
                        cfw.add((byte)-64, "java/lang/Byte");
                        cfw.add((byte)-74, "java/lang/Byte", "byteValue", "()", "B");
                        params.append('B');
                    }
                } else {
                    String typeName = type.getName().replace('.', '/');
                    cfw.add((byte)-64, typeName);
                    if (!type.isArray()) {
                        params.append('L');
                    }
                    params.append(typeName);
                    if (!type.isArray()) {
                        params.append(';');
                    }
                }
                ++i;
            }
        }
        params.append(')');
        if (!Modifier.isStatic(method.getModifiers())) {
            cfw.add((byte)-74, declaringClassName, method.getName(), params.toString(), invokeSpecialType != null ? invokeSpecialType.substring(1, 2) : (returnType.isArray() ? returnType.getName().replace('.', '/') : "L".concat(returnType.getName().replace('.', '/').concat(";"))));
        } else {
            cfw.add((byte)-72, declaringClassName, method.getName(), params.toString(), invokeSpecialType != null ? invokeSpecialType.substring(1, 2) : (returnType.isArray() ? returnType.getName().replace('.', '/') : "L".concat(returnType.getName().replace('.', '/').concat(";"))));
        }
        if (returnsVoid) {
            cfw.add((byte)1);
            cfw.add((byte)-80);
        } else if (returnsBoolean) {
            cfw.add((byte)-103, 7);
            cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            cfw.add((byte)-80);
            cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            cfw.add((byte)-80);
        } else if (invokeSpecial != null) {
            cfw.add((byte)-73, invokeSpecial, "<init>", invokeSpecialType, "V");
            cfw.add((byte)-80);
        } else {
            cfw.add((byte)-80);
        }
        cfw.stopMethod((short)3, null);
        byte[] bytes = cfw.toByteArray();
        Class c = this.classLoader.defineClass(className, bytes);
        this.classLoader.linkClass(c);
        try {
            result = (Invoker)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unexpected " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unexpected " + e.toString());
        }
        this.invokersCache.put(method, result);
        return result;
    }

    public Object invoke(Object that, Object[] args) {
        return null;
    }
}

