import com.sun.star.scripting.runtime.java.ScriptRuntimeForJava;
import com.sun.star.scripting.runtime.java.ExceptionTraceHelper;

import drafts.com.sun.star.script.framework.runtime.XScriptContext;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;
import com.sun.star.text.*;
import com.sun.star.document.XEventsSupplier;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNameReplace;

import java.io.*;

/**
 *  ScriptFrmwrkHelper class
 *  interface for the ScriptFrmwrkHelper class
 *
 * @author      Neil Montgomery
 * @created     September 23, 2002
 */
public class ScriptFrmwrkHelper 
{
    /*
     * Removes named document event
     *
     * @param   String eventName
     */
    public static void removeEvent(XScriptContext xSc, String eventName) 
    {
        ScriptRuntimeForJava.DEBUG("In removeEvent, remove for " + eventName );
        try
        {
            XEventsSupplier xEventSupplier = ( XEventsSupplier )UnoRuntime.queryInterface( XEventsSupplier.class, xSc.getDocument() );
            XNameReplace  replace = xEventSupplier.getEvents();
            PropertyValue[] noEvent = new com.sun.star.beans.PropertyValue[0];
            replace.replaceByName ( eventName, noEvent );
        }
        catch ( Exception e )
        {
            ScriptRuntimeForJava.DEBUG("Caught exception " + e );
            String trace = ExceptionTraceHelper.getTrace( e );
            ScriptRuntimeForJava.DEBUG( trace );
        }
        
    }
    /*
     * Removes named document event
     *
     * @param   String eventName
     */
    public static void updateCfgFile(XScriptContext ctx,String[] xmlFile, String fileName, Byte noLines) throws IOException
    {
       ScriptFrmwrkHelper.updateConfigFile( ctx, xmlFile, fileName, noLines.intValue() ); 
    }

    /*
     * Removes named document event
     *
     * @param   String eventName
     */
    public static void updateCfgFile(XScriptContext ctx,String[] xmlFile, String fileName, Short noLines) throws IOException 
    {
       ScriptFrmwrkHelper.updateConfigFile( ctx, xmlFile, fileName, noLines.intValue() ); 
    }

    static private void updateConfigFile( XScriptContext ctx, String[] xmlFile, String fileName, int numberOfLines) throws IOException
    {
        ScriptRuntimeForJava.DEBUG("In updateCfgFile " + fileName + " array with " + xmlFile.length + " passed in and number of lines to process = " + numberOfLines );
        int index = 0;
        try
        {
            PrintStream writer = new PrintStream ( new FileOutputStream( fileName ) );
            for ( index = 1; index < numberOfLines + 1; index++ )
            {
                String lineToWrite = xmlFile[ index ];
                if ( lineToWrite.length() > 0 )
                {
                    if ( index != numberOfLines )
                    {
                        writer.println( lineToWrite );
                    }
                    else
                    {
                        writer.print( lineToWrite );
                    }
                }
           
            }
        }
        catch ( IOException e ) 
        {
            ScriptRuntimeForJava.DEBUG("Error writing config file, failed at index " + index );
            ScriptRuntimeForJava.DEBUG("processing file " + fileName );
            ScriptRuntimeForJava.DEBUG("Exception: " + e );
            String trace = ExceptionTraceHelper.getTrace( e );
            ScriptRuntimeForJava.DEBUG( trace );
            throw new IOException( trace );
        }
    }    

}// 
